/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FlutterDash: ImageVector
    get() {
        if (_flutterDash != null) {
            return _flutterDash!!
        }
        _flutterDash = materialIcon(name = "TwoTone.FlutterDash") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 11.0f)
                curveToRelative(0.0f, 0.81f, 0.1f, 1.53f, 0.25f, 2.21f)
                curveToRelative(0.18f, -0.69f, 0.46f, -1.33f, 0.83f, -1.92f)
                curveToRelative(-0.21f, -0.47f, -0.34f, -0.99f, -0.34f, -1.54f)
                curveTo(5.75f, 7.68f, 7.43f, 6.0f, 9.5f, 6.0f)
                curveToRelative(0.96f, 0.0f, 1.84f, 0.37f, 2.5f, 0.97f)
                curveTo(12.66f, 6.37f, 13.54f, 6.0f, 14.5f, 6.0f)
                curveToRelative(2.07f, 0.0f, 3.75f, 1.68f, 3.75f, 3.75f)
                curveToRelative(0.0f, 0.55f, -0.12f, 1.07f, -0.34f, 1.54f)
                curveToRelative(0.37f, 0.59f, 0.66f, 1.24f, 0.84f, 1.94f)
                curveTo(18.9f, 12.55f, 19.0f, 11.82f, 19.0f, 11.0f)
                curveToRelative(0.0f, -3.86f, -3.14f, -7.0f, -7.0f, -7.0f)
                curveTo(8.14f, 4.0f, 5.0f, 7.14f, 5.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(11.07f, 11.7f)
                curveToRelative(0.29f, -0.39f, 0.81f, -0.56f, 1.27f, -0.37f)
                curveToRelative(0.17f, 0.07f, 0.32f, 0.18f, 0.43f, 0.33f)
                curveToRelative(0.22f, 0.28f, 0.25f, 0.59f, 0.22f, 0.85f)
                curveToRelative(-0.05f, 0.33f, -0.25f, 0.63f, -0.54f, 0.79f)
                curveToRelative(0.0f, 0.0f, -4.87f, 2.95f, -5.07f, 2.69f)
                reflectiveCurveTo(11.07f, 11.7f, 11.07f, 11.7f)
                close()
                moveTo(22.0f, 10.0f)
                curveToRelative(0.0f, 2.5f, -1.0f, 3.0f, -1.5f, 3.0f)
                curveToRelative(-0.23f, 0.0f, -0.44f, -0.1f, -0.62f, -0.26f)
                curveToRelative(-0.48f, 3.32f, -2.36f, 5.31f, -5.33f, 5.99f)
                curveToRelative(0.11f, 0.44f, 0.48f, 0.77f, 0.95f, 0.77f)
                lineToRelative(0.0f, 0.0f)
                horizontalLineToRelative(0.58f)
                curveToRelative(0.22f, 0.0f, 0.41f, 0.15f, 0.48f, 0.36f)
                curveToRelative(0.17f, 0.52f, 0.66f, 1.02f, 1.02f, 1.32f)
                curveToRelative(0.25f, 0.21f, 0.24f, 0.59f, -0.03f, 0.78f)
                curveToRelative(-0.34f, 0.24f, -0.9f, 0.49f, -1.79f, 0.53f)
                curveToRelative(-0.18f, 0.01f, -0.35f, -0.07f, -0.45f, -0.22f)
                curveTo(15.18f, 22.07f, 15.0f, 21.71f, 15.0f, 21.26f)
                curveToRelative(0.0f, -0.3f, 0.04f, -0.57f, 0.09f, -0.8f)
                curveToRelative(-0.78f, -0.16f, -1.39f, -0.78f, -1.55f, -1.56f)
                curveToRelative(-0.49f, 0.06f, -1.0f, 0.1f, -1.54f, 0.1f)
                curveToRelative(-0.88f, 0.0f, -1.7f, -0.09f, -2.45f, -0.25f)
                curveTo(9.53f, 18.83f, 9.5f, 18.91f, 9.5f, 19.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                lineToRelative(0.0f, 0.0f)
                horizontalLineToRelative(0.58f)
                curveToRelative(0.22f, 0.0f, 0.41f, 0.15f, 0.48f, 0.36f)
                curveToRelative(0.17f, 0.52f, 0.66f, 1.02f, 1.02f, 1.32f)
                curveToRelative(0.25f, 0.21f, 0.24f, 0.59f, -0.03f, 0.78f)
                curveToRelative(-0.34f, 0.24f, -0.9f, 0.49f, -1.79f, 0.53f)
                curveToRelative(-0.18f, 0.01f, -0.35f, -0.07f, -0.45f, -0.22f)
                curveTo(10.18f, 22.57f, 10.0f, 22.21f, 10.0f, 21.76f)
                curveToRelative(0.0f, -0.3f, 0.04f, -0.57f, 0.09f, -0.8f)
                curveTo(9.19f, 20.77f, 8.5f, 19.96f, 8.5f, 19.0f)
                curveToRelative(0.0f, -0.18f, 0.03f, -0.36f, 0.08f, -0.53f)
                curveToRelative(-2.46f, -0.86f, -4.03f, -2.78f, -4.46f, -5.74f)
                curveTo(3.94f, 12.9f, 3.74f, 13.0f, 3.5f, 13.0f)
                curveTo(3.0f, 13.0f, 2.0f, 12.5f, 2.0f, 10.0f)
                curveToRelative(0.0f, -2.27f, 1.7f, -4.5f, 3.0f, -4.5f)
                curveToRelative(0.43f, 0.0f, 0.49f, 0.49f, 0.5f, 0.85f)
                curveToRelative(1.28f, -1.78f, 3.26f, -3.02f, 5.55f, -3.29f)
                curveTo(11.25f, 2.1f, 12.13f, 1.5f, 13.0f, 1.5f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.0f, 0.33f, -0.5f, 1.0f, -0.5f)
                curveToRelative(0.67f, 0.0f, 1.0f, 0.5f, 1.0f, 0.5f)
                curveToRelative(-0.49f, 0.0f, -0.85f, 0.35f, -0.96f, 0.77f)
                curveToRelative(1.82f, 0.48f, 3.39f, 1.59f, 4.46f, 3.08f)
                curveTo(18.51f, 5.99f, 18.57f, 5.5f, 19.0f, 5.5f)
                curveTo(20.3f, 5.5f, 22.0f, 7.73f, 22.0f, 10.0f)
                close()
                moveTo(5.0f, 11.0f)
                curveToRelative(0.0f, 0.81f, 0.1f, 1.53f, 0.25f, 2.21f)
                curveToRelative(0.18f, -0.69f, 0.46f, -1.33f, 0.83f, -1.92f)
                curveToRelative(-0.21f, -0.47f, -0.34f, -0.99f, -0.34f, -1.54f)
                curveTo(5.75f, 7.68f, 7.43f, 6.0f, 9.5f, 6.0f)
                curveToRelative(0.96f, 0.0f, 1.84f, 0.37f, 2.5f, 0.97f)
                curveTo(12.66f, 6.37f, 13.54f, 6.0f, 14.5f, 6.0f)
                curveToRelative(2.07f, 0.0f, 3.75f, 1.68f, 3.75f, 3.75f)
                curveToRelative(0.0f, 0.55f, -0.12f, 1.07f, -0.34f, 1.54f)
                curveToRelative(0.37f, 0.59f, 0.66f, 1.24f, 0.84f, 1.94f)
                curveTo(18.9f, 12.55f, 19.0f, 11.82f, 19.0f, 11.0f)
                curveToRelative(0.0f, -3.86f, -3.14f, -7.0f, -7.0f, -7.0f)
                curveTo(8.14f, 4.0f, 5.0f, 7.14f, 5.0f, 11.0f)
                close()
                moveTo(17.98f, 15.29f)
                curveToRelative(0.0f, -0.1f, 0.02f, -0.19f, 0.02f, -0.29f)
                curveToRelative(0.0f, -1.01f, -0.26f, -1.95f, -0.7f, -2.78f)
                curveToRelative(-0.69f, 0.78f, -1.68f, 1.28f, -2.8f, 1.28f)
                curveToRelative(-0.27f, 0.0f, -0.54f, -0.03f, -0.79f, -0.09f)
                curveToRelative(0.14f, -0.23f, 0.23f, -0.49f, 0.27f, -0.77f)
                curveToRelative(0.01f, -0.07f, 0.01f, -0.13f, 0.02f, -0.19f)
                curveToRelative(0.17f, 0.03f, 0.33f, 0.05f, 0.5f, 0.05f)
                curveToRelative(1.52f, 0.0f, 2.75f, -1.23f, 2.75f, -2.75f)
                reflectiveCurveTo(16.02f, 7.0f, 14.5f, 7.0f)
                curveToRelative(-0.67f, 0.0f, -1.32f, 0.25f, -1.83f, 0.72f)
                lineTo(12.0f, 8.32f)
                lineToRelative(-0.67f, -0.6f)
                curveTo(10.82f, 7.25f, 10.17f, 7.0f, 9.5f, 7.0f)
                curveTo(7.98f, 7.0f, 6.75f, 8.23f, 6.75f, 9.75f)
                curveToRelative(0.0f, 1.34f, 0.96f, 2.46f, 2.23f, 2.7f)
                lineToRelative(-0.76f, 0.83f)
                curveToRelative(-0.6f, -0.22f, -1.12f, -0.59f, -1.53f, -1.05f)
                curveTo(6.26f, 13.06f, 6.0f, 14.0f, 6.0f, 15.0f)
                curveToRelative(0.0f, 0.08f, 0.01f, 0.15f, 0.01f, 0.24f)
                curveTo(7.13f, 17.06f, 9.14f, 18.0f, 12.0f, 18.0f)
                curveTo(14.88f, 18.0f, 16.88f, 17.09f, 17.98f, 15.29f)
                close()
                moveTo(16.0f, 9.75f)
                curveToRelative(0.0f, 0.97f, -0.67f, 1.75f, -1.5f, 1.75f)
                reflectiveCurveTo(13.0f, 10.72f, 13.0f, 9.75f)
                reflectiveCurveTo(13.67f, 8.0f, 14.5f, 8.0f)
                reflectiveCurveTo(16.0f, 8.78f, 16.0f, 9.75f)
                close()
                moveTo(15.25f, 8.88f)
                curveToRelative(0.0f, -0.21f, -0.17f, -0.38f, -0.38f, -0.38f)
                reflectiveCurveTo(14.5f, 8.67f, 14.5f, 8.88f)
                reflectiveCurveToRelative(0.17f, 0.38f, 0.38f, 0.38f)
                reflectiveCurveTo(15.25f, 9.08f, 15.25f, 8.88f)
                close()
                moveTo(11.0f, 9.75f)
                curveToRelative(0.0f, 0.97f, -0.67f, 1.75f, -1.5f, 1.75f)
                reflectiveCurveTo(8.0f, 10.72f, 8.0f, 9.75f)
                reflectiveCurveTo(8.67f, 8.0f, 9.5f, 8.0f)
                reflectiveCurveTo(11.0f, 8.78f, 11.0f, 9.75f)
                close()
                moveTo(10.25f, 8.88f)
                curveToRelative(0.0f, -0.21f, -0.17f, -0.38f, -0.38f, -0.38f)
                reflectiveCurveTo(9.5f, 8.67f, 9.5f, 8.88f)
                reflectiveCurveToRelative(0.17f, 0.38f, 0.38f, 0.38f)
                reflectiveCurveTo(10.25f, 9.08f, 10.25f, 8.88f)
                close()
            }
        }
        return _flutterDash!!
    }

private var _flutterDash: ImageVector? = null
