/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Diversity2: ImageVector
    get() {
        if (_diversity2 != null) {
            return _diversity2!!
        }
        _diversity2 = materialIcon(name = "TwoTone.Diversity2") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(2.5f, 17.97f)
                curveToRelative(-0.48f, 0.28f, -0.64f, 0.89f, -0.37f, 1.37f)
                reflectiveCurveToRelative(0.89f, 0.64f, 1.37f, 0.37f)
                curveToRelative(0.48f, -0.28f, 0.64f, -0.89f, 0.37f, -1.37f)
                reflectiveCurveTo(2.98f, 17.69f, 2.5f, 17.97f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(21.5f, 17.97f)
                curveToRelative(-0.48f, -0.28f, -1.09f, -0.11f, -1.37f, 0.37f)
                reflectiveCurveToRelative(-0.11f, 1.09f, 0.37f, 1.37f)
                curveToRelative(0.48f, 0.28f, 1.09f, 0.11f, 1.37f, -0.37f)
                reflectiveCurveTo(21.98f, 18.24f, 21.5f, 17.97f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(10.1f, 15.9f)
                lineToRelative(1.42f, -1.42f)
                curveTo(8.79f, 12.05f, 7.0f, 10.41f, 7.0f, 8.85f)
                curveTo(7.0f, 7.8f, 7.8f, 7.0f, 8.85f, 7.0f)
                curveToRelative(1.11f, 0.0f, 1.54f, 0.65f, 2.68f, 2.0f)
                horizontalLineToRelative(0.93f)
                curveToRelative(1.12f, -1.31f, 1.53f, -2.0f, 2.68f, -2.0f)
                curveToRelative(0.87f, 0.0f, 1.55f, 0.54f, 1.77f, 1.32f)
                curveToRelative(0.35f, -0.04f, 0.68f, -0.06f, 1.0f, -0.06f)
                curveToRelative(0.36f, 0.0f, 0.7f, 0.03f, 1.03f, 0.08f)
                curveTo(18.7f, 6.43f, 17.13f, 5.0f, 15.15f, 5.0f)
                curveToRelative(-0.12f, 0.0f, -0.23f, 0.03f, -0.35f, 0.04f)
                curveTo(14.92f, 4.71f, 15.0f, 4.37f, 15.0f, 4.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(9.0f, 2.34f, 9.0f, 4.0f)
                curveToRelative(0.0f, 0.37f, 0.08f, 0.71f, 0.2f, 1.04f)
                curveTo(9.08f, 5.03f, 8.97f, 5.0f, 8.85f, 5.0f)
                curveTo(6.69f, 5.0f, 5.0f, 6.69f, 5.0f, 8.85f)
                curveTo(5.0f, 11.27f, 7.04f, 13.16f, 10.1f, 15.9f)
                close()
                moveTo(12.0f, 3.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveTo(11.45f, 3.0f, 12.0f, 3.0f)
                close()
            }
            materialPath {
                moveTo(22.5f, 16.24f)
                curveToRelative(-0.32f, -0.18f, -0.66f, -0.29f, -1.0f, -0.35f)
                curveToRelative(0.07f, -0.1f, 0.15f, -0.18f, 0.21f, -0.28f)
                curveToRelative(1.08f, -1.87f, 0.46f, -4.18f, -1.41f, -5.26f)
                curveToRelative(-2.09f, -1.21f, -4.76f, -0.39f, -8.65f, 0.9f)
                lineToRelative(0.52f, 1.94f)
                curveToRelative(3.47f, -1.14f, 5.79f, -1.88f, 7.14f, -1.1f)
                curveToRelative(0.91f, 0.53f, 1.2f, 1.61f, 0.68f, 2.53f)
                curveToRelative(-0.56f, 0.96f, -1.33f, 1.0f, -3.07f, 1.32f)
                lineToRelative(-0.47f, 0.81f)
                curveToRelative(0.58f, 1.62f, 0.97f, 2.33f, 0.39f, 3.32f)
                curveToRelative(-0.53f, 0.91f, -1.61f, 1.2f, -2.53f, 0.68f)
                curveToRelative(-0.06f, -0.03f, -0.11f, -0.09f, -0.17f, -0.13f)
                curveToRelative(-0.3f, 0.67f, -0.64f, 1.24f, -1.03f, 1.73f)
                curveToRelative(0.07f, 0.04f, 0.13f, 0.09f, 0.2f, 0.14f)
                curveToRelative(1.87f, 1.08f, 4.18f, 0.46f, 5.26f, -1.41f)
                curveToRelative(0.06f, -0.1f, 0.09f, -0.21f, 0.14f, -0.32f)
                curveToRelative(0.22f, 0.27f, 0.48f, 0.51f, 0.8f, 0.69f)
                curveToRelative(1.43f, 0.83f, 3.27f, 0.34f, 4.1f, -1.1f)
                reflectiveCurveTo(23.93f, 17.06f, 22.5f, 16.24f)
                close()
                moveTo(21.87f, 19.33f)
                curveToRelative(-0.28f, 0.48f, -0.89f, 0.64f, -1.37f, 0.37f)
                curveToRelative(-0.48f, -0.28f, -0.64f, -0.89f, -0.37f, -1.37f)
                reflectiveCurveToRelative(0.89f, -0.64f, 1.37f, -0.37f)
                curveTo(21.98f, 18.24f, 22.14f, 18.86f, 21.87f, 19.33f)
                close()
            }
            materialPath {
                moveTo(12.32f, 14.01f)
                curveToRelative(-0.74f, 3.58f, -1.27f, 5.95f, -2.62f, 6.73f)
                curveToRelative(-0.91f, 0.53f, -2.0f, 0.24f, -2.53f, -0.68f)
                curveToRelative(-0.56f, -0.96f, -0.2f, -1.66f, 0.39f, -3.32f)
                lineTo(7.1f, 15.93f)
                curveToRelative(-1.7f, -0.31f, -2.5f, -0.33f, -3.07f, -1.32f)
                curveToRelative(-0.53f, -0.91f, -0.24f, -2.0f, 0.68f, -2.53f)
                curveToRelative(0.09f, -0.05f, 0.19f, -0.08f, 0.29f, -0.11f)
                curveToRelative(-0.35f, -0.56f, -0.64f, -1.17f, -0.82f, -1.85f)
                curveToRelative(-0.16f, 0.07f, -0.32f, 0.14f, -0.48f, 0.23f)
                curveToRelative(-1.87f, 1.08f, -2.49f, 3.39f, -1.41f, 5.26f)
                curveToRelative(0.06f, 0.1f, 0.14f, 0.18f, 0.21f, 0.28f)
                curveToRelative(-0.34f, 0.06f, -0.68f, 0.17f, -1.0f, 0.35f)
                curveToRelative(-1.43f, 0.83f, -1.93f, 2.66f, -1.1f, 4.1f)
                reflectiveCurveToRelative(2.66f, 1.93f, 4.1f, 1.1f)
                curveToRelative(0.32f, -0.18f, 0.58f, -0.42f, 0.8f, -0.69f)
                curveToRelative(0.05f, 0.11f, 0.08f, 0.22f, 0.14f, 0.32f)
                curveToRelative(1.08f, 1.87f, 3.39f, 2.49f, 5.26f, 1.41f)
                curveToRelative(2.09f, -1.21f, 2.71f, -3.93f, 3.55f, -7.94f)
                lineTo(12.32f, 14.01f)
                close()
                moveTo(3.5f, 19.7f)
                curveToRelative(-0.48f, 0.28f, -1.09f, 0.11f, -1.37f, -0.37f)
                reflectiveCurveToRelative(-0.11f, -1.09f, 0.37f, -1.37f)
                curveToRelative(0.48f, -0.28f, 1.09f, -0.11f, 1.37f, 0.37f)
                reflectiveCurveTo(3.98f, 19.42f, 3.5f, 19.7f)
                close()
            }
        }
        return _diversity2!!
    }

private var _diversity2: ImageVector? = null
