/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VerticalShadesClosed: ImageVector
    get() {
        if (_verticalShadesClosed != null) {
            return _verticalShadesClosed!!
        }
        _verticalShadesClosed = materialIcon(name = "Sharp.VerticalShadesClosed") {
            materialPath {
                moveTo(20.0f, 19.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(16.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(20.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(13.0f, 5.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(14.0f)
                horizontalLineTo(13.0f)
                verticalLineTo(5.0f)
                close()
                moveTo(11.0f, 19.0f)
                horizontalLineTo(9.5f)
                verticalLineTo(5.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(6.0f, 5.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(14.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(5.0f)
                close()
                moveTo(16.5f, 19.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(14.0f)
                horizontalLineTo(16.5f)
                close()
            }
        }
        return _verticalShadesClosed!!
    }

private var _verticalShadesClosed: ImageVector? = null
