/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SignalWifiOff: ImageVector
    get() {
        if (_signalWifiOff != null) {
            return _signalWifiOff!!
        }
        _signalWifiOff = materialIcon(name = "Sharp.SignalWifiOff") {
            materialPath {
                moveTo(23.64f, 7.0f)
                curveToRelative(-0.45f, -0.34f, -4.93f, -4.0f, -11.64f, -4.0f)
                curveToRelative(-1.32f, 0.0f, -2.55f, 0.14f, -3.69f, 0.38f)
                lineTo(18.43f, 13.5f)
                lineTo(23.64f, 7.0f)
                close()
                moveTo(3.41f, 1.31f)
                lineTo(2.0f, 2.72f)
                lineToRelative(2.05f, 2.05f)
                curveTo(1.91f, 5.76f, 0.59f, 6.82f, 0.36f, 7.0f)
                lineTo(12.0f, 21.5f)
                lineToRelative(3.91f, -4.87f)
                lineToRelative(3.32f, 3.32f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.41f, 1.31f)
                close()
            }
        }
        return _signalWifiOff!!
    }

private var _signalWifiOff: ImageVector? = null
