/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.OfflineShare: ImageVector
    get() {
        if (_offlineShare != null) {
            return _offlineShare!!
        }
        _offlineShare = materialIcon(name = "Sharp.OfflineShare") {
            materialPath {
                moveTo(6.0f, 5.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 18.0f)
                lineToRelative(12.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-10.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 1.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(18.0f)
                horizontalLineToRelative(12.0f)
                verticalLineTo(1.0f)
                close()
                moveTo(18.0f, 15.0f)
                horizontalLineToRelative(-8.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(15.0f)
                close()
            }
            materialPath {
                moveTo(12.5f, 10.25f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, 1.75f)
                lineToRelative(2.5f, -2.5f)
                lineToRelative(-2.5f, -2.5f)
                lineToRelative(0.0f, 1.75f)
                lineToRelative(-3.5f, 0.0f)
                lineToRelative(0.0f, 3.25f)
                lineToRelative(1.5f, 0.0f)
                close()
            }
        }
        return _offlineShare!!
    }

private var _offlineShare: ImageVector? = null
