/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ChromeReaderMode: ImageVector
    get() {
        if (_chromeReaderMode != null) {
            return _chromeReaderMode!!
        }
        _chromeReaderMode = materialIcon(name = "Sharp.ChromeReaderMode") {
            materialPath {
                moveTo(13.0f, 12.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-7.0f)
                lineTo(13.0f, 12.0f)
                close()
                moveTo(13.0f, 9.5f)
                horizontalLineToRelative(7.0f)
                lineTo(20.0f, 11.0f)
                horizontalLineToRelative(-7.0f)
                lineTo(13.0f, 9.5f)
                close()
                moveTo(13.0f, 14.5f)
                horizontalLineToRelative(7.0f)
                lineTo(20.0f, 16.0f)
                horizontalLineToRelative(-7.0f)
                verticalLineToRelative(-1.5f)
                close()
                moveTo(23.0f, 4.0f)
                lineTo(1.0f, 4.0f)
                verticalLineToRelative(17.0f)
                horizontalLineToRelative(22.0f)
                lineTo(23.0f, 4.0f)
                close()
                moveTo(21.0f, 19.0f)
                horizontalLineToRelative(-9.0f)
                lineTo(12.0f, 6.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(13.0f)
                close()
            }
        }
        return _chromeReaderMode!!
    }

private var _chromeReaderMode: ImageVector? = null
