/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.MoveDown: ImageVector
    get() {
        if (_moveDown != null) {
            return _moveDown!!
        }
        _moveDown = materialIcon(name = "Rounded.MoveDown") {
            materialPath {
                moveTo(3.01f, 10.72f)
                curveToRelative(-0.14f, 2.57f, 1.66f, 4.73f, 4.07f, 5.18f)
                lineToRelative(-0.79f, -0.79f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(2.59f, 2.59f)
                curveToRelative(0.39f, 0.39f, 0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(7.71f, 20.3f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(0.88f, -0.88f)
                lineToRelative(0.0f, -0.06f)
                curveToRelative(-3.64f, -0.43f, -6.43f, -3.65f, -6.15f, -7.47f)
                curveTo(1.29f, 6.78f, 4.55f, 4.0f, 8.26f, 4.0f)
                lineTo(10.0f, 4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                lineTo(8.22f, 6.0f)
                curveTo(5.52f, 6.0f, 3.15f, 8.04f, 3.01f, 10.72f)
                close()
            }
            materialPath {
                moveTo(15.0f, 11.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(3.0f)
                curveTo(13.0f, 10.1f, 13.9f, 11.0f, 15.0f, 11.0f)
                close()
                moveTo(20.0f, 9.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(9.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(3.0f)
                curveTo(22.0f, 19.1f, 21.1f, 20.0f, 20.0f, 20.0f)
                close()
            }
        }
        return _moveDown!!
    }

private var _moveDown: ImageVector? = null
