/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ImportContacts: ImageVector
    get() {
        if (_importContacts != null) {
            return _importContacts!!
        }
        _importContacts = materialIcon(name = "Rounded.ImportContacts") {
            materialPath {
                moveTo(17.5f, 4.5f)
                curveToRelative(-1.95f, 0.0f, -4.05f, 0.4f, -5.5f, 1.5f)
                curveToRelative(-1.45f, -1.1f, -3.55f, -1.5f, -5.5f, -1.5f)
                curveToRelative(-1.45f, 0.0f, -2.99f, 0.22f, -4.28f, 0.79f)
                curveTo(1.49f, 5.62f, 1.0f, 6.33f, 1.0f, 7.14f)
                verticalLineToRelative(11.28f)
                curveToRelative(0.0f, 1.3f, 1.22f, 2.26f, 2.48f, 1.94f)
                curveToRelative(0.98f, -0.25f, 2.02f, -0.36f, 3.02f, -0.36f)
                curveToRelative(1.56f, 0.0f, 3.22f, 0.26f, 4.56f, 0.92f)
                curveToRelative(0.6f, 0.3f, 1.28f, 0.3f, 1.87f, 0.0f)
                curveToRelative(1.34f, -0.67f, 3.0f, -0.92f, 4.56f, -0.92f)
                curveToRelative(1.0f, 0.0f, 2.04f, 0.11f, 3.02f, 0.36f)
                curveToRelative(1.26f, 0.33f, 2.48f, -0.63f, 2.48f, -1.94f)
                verticalLineTo(7.14f)
                curveToRelative(0.0f, -0.81f, -0.49f, -1.52f, -1.22f, -1.85f)
                curveToRelative(-1.28f, -0.57f, -2.82f, -0.79f, -4.27f, -0.79f)
                close()
                moveTo(21.0f, 17.23f)
                curveToRelative(0.0f, 0.63f, -0.58f, 1.09f, -1.2f, 0.98f)
                curveToRelative(-0.75f, -0.14f, -1.53f, -0.2f, -2.3f, -0.2f)
                curveToRelative(-1.7f, 0.0f, -4.15f, 0.65f, -5.5f, 1.5f)
                verticalLineTo(8.0f)
                curveToRelative(1.35f, -0.85f, 3.8f, -1.5f, 5.5f, -1.5f)
                curveToRelative(0.92f, 0.0f, 1.83f, 0.09f, 2.7f, 0.28f)
                curveToRelative(0.46f, 0.1f, 0.8f, 0.51f, 0.8f, 0.98f)
                verticalLineToRelative(9.47f)
                close()
            }
        }
        return _importContacts!!
    }

private var _importContacts: ImageVector? = null
