/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Gite: ImageVector
    get() {
        if (_gite != null) {
            return _gite!!
        }
        _gite = materialIcon(name = "Rounded.Gite") {
            materialPath {
                moveTo(21.41f, 9.41f)
                lineToRelative(-2.83f, -2.83f)
                curveTo(18.21f, 6.21f, 17.7f, 6.0f, 17.17f, 6.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                reflectiveCurveTo(7.0f, 4.45f, 7.0f, 5.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(6.83f)
                curveTo(6.3f, 6.0f, 5.79f, 6.21f, 5.41f, 6.59f)
                lineTo(2.59f, 9.41f)
                curveTo(2.21f, 9.79f, 2.0f, 10.3f, 2.0f, 10.83f)
                verticalLineTo(17.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-6.17f)
                curveTo(22.0f, 10.3f, 21.79f, 9.79f, 21.41f, 9.41f)
                close()
                moveTo(14.0f, 17.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(20.0f, 17.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-6.17f)
                lineToRelative(2.0f, -2.0f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(17.0f)
                close()
            }
        }
        return _gite!!
    }

private var _gite: ImageVector? = null
