/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CameraIndoor: ImageVector
    get() {
        if (_cameraIndoor != null) {
            return _cameraIndoor!!
        }
        _cameraIndoor = materialIcon(name = "Rounded.CameraIndoor") {
            materialPath {
                moveTo(10.8f, 3.65f)
                lineToRelative(-6.0f, 4.5f)
                curveTo(4.3f, 8.53f, 4.0f, 9.12f, 4.0f, 9.75f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(12.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-9.0f)
                curveToRelative(0.0f, -0.63f, -0.3f, -1.22f, -0.8f, -1.6f)
                lineToRelative(-6.0f, -4.5f)
                curveTo(12.49f, 3.12f, 11.51f, 3.12f, 10.8f, 3.65f)
                close()
                moveTo(15.27f, 15.67f)
                lineTo(14.0f, 15.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                lineToRelative(1.27f, -0.67f)
                curveTo(15.6f, 12.15f, 16.0f, 12.39f, 16.0f, 12.77f)
                verticalLineToRelative(2.46f)
                curveTo(16.0f, 15.61f, 15.6f, 15.85f, 15.27f, 15.67f)
                close()
            }
        }
        return _cameraIndoor!!
    }

private var _cameraIndoor: ImageVector? = null
