/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.BedtimeOff: ImageVector
    get() {
        if (_bedtimeOff != null) {
            return _bedtimeOff!!
        }
        _bedtimeOff = materialIcon(name = "Rounded.BedtimeOff") {
            materialPath {
                moveTo(11.65f, 3.46f)
                curveToRelative(0.27f, -0.71f, -0.36f, -1.45f, -1.12f, -1.34f)
                curveTo(9.05f, 2.33f, 7.68f, 2.88f, 6.49f, 3.66f)
                lineToRelative(4.59f, 4.59f)
                curveTo(10.88f, 6.69f, 11.04f, 5.05f, 11.65f, 3.46f)
                close()
            }
            materialPath {
                moveTo(2.1f, 3.51f)
                lineTo(2.1f, 3.51f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(1.56f, 1.56f)
                curveToRelative(-1.4f, 2.11f, -2.02f, 4.77f, -1.46f, 7.56f)
                curveToRelative(0.79f, 3.94f, 3.99f, 7.07f, 7.94f, 7.78f)
                curveToRelative(2.74f, 0.49f, 5.3f, -0.15f, 7.35f, -1.51f)
                lineToRelative(1.57f, 1.57f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(3.51f, 3.51f)
                curveTo(3.12f, 3.12f, 2.49f, 3.12f, 2.1f, 3.51f)
                close()
            }
        }
        return _bedtimeOff!!
    }

private var _bedtimeOff: ImageVector? = null
