/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AlignHorizontalCenter: ImageVector
    get() {
        if (_alignHorizontalCenter != null) {
            return _alignHorizontalCenter!!
        }
        _alignHorizontalCenter = materialIcon(name = "Rounded.AlignHorizontalCenter") {
            materialPath {
                moveTo(12.0f, 2.0f)
                lineTo(12.0f, 2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(6.5f, 0.0f)
                curveTo(20.33f, 7.0f, 21.0f, 7.67f, 21.0f, 8.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(3.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                horizontalLineTo(13.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(7.5f)
                curveTo(6.67f, 17.0f, 6.0f, 16.33f, 6.0f, 15.5f)
                verticalLineToRelative(0.0f)
                curveTo(6.0f, 14.67f, 6.67f, 14.0f, 7.5f, 14.0f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(4.5f)
                curveTo(3.67f, 10.0f, 3.0f, 9.33f, 3.0f, 8.5f)
                verticalLineToRelative(0.0f)
                curveTo(3.0f, 7.67f, 3.67f, 7.0f, 4.5f, 7.0f)
                horizontalLineTo(11.0f)
                lineToRelative(0.0f, -4.0f)
                curveTo(11.0f, 2.45f, 11.45f, 2.0f, 12.0f, 2.0f)
                close()
            }
        }
        return _alignHorizontalCenter!!
    }

private var _alignHorizontalCenter: ImageVector? = null
