/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AccessibilityNew: ImageVector
    get() {
        if (_accessibilityNew != null) {
            return _accessibilityNew!!
        }
        _accessibilityNew = materialIcon(name = "Rounded.AccessibilityNew") {
            materialPath {
                moveTo(20.75f, 6.99f)
                curveToRelative(-0.14f, -0.55f, -0.69f, -0.87f, -1.24f, -0.75f)
                curveToRelative(-2.38f, 0.53f, -5.03f, 0.76f, -7.51f, 0.76f)
                reflectiveCurveToRelative(-5.13f, -0.23f, -7.51f, -0.76f)
                curveToRelative(-0.55f, -0.12f, -1.1f, 0.2f, -1.24f, 0.75f)
                curveToRelative(-0.14f, 0.56f, 0.2f, 1.13f, 0.75f, 1.26f)
                curveToRelative(1.61f, 0.36f, 3.35f, 0.61f, 5.0f, 0.75f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(9.0f)
                curveToRelative(1.65f, -0.14f, 3.39f, -0.39f, 4.99f, -0.75f)
                curveToRelative(0.56f, -0.13f, 0.9f, -0.7f, 0.76f, -1.26f)
                close()
                moveTo(12.0f, 6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                close()
            }
        }
        return _accessibilityNew!!
    }

private var _accessibilityNew: ImageVector? = null
