/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NightlightRound: ImageVector
    get() {
        if (_nightlightRound != null) {
            return _nightlightRound!!
        }
        _nightlightRound = materialIcon(name = "Outlined.NightlightRound") {
            materialPath {
                moveTo(15.5f, 22.0f)
                curveToRelative(1.05f, 0.0f, 2.05f, -0.16f, 3.0f, -0.46f)
                curveToRelative(-4.06f, -1.27f, -7.0f, -5.06f, -7.0f, -9.54f)
                reflectiveCurveToRelative(2.94f, -8.27f, 7.0f, -9.54f)
                curveTo(17.55f, 2.16f, 16.55f, 2.0f, 15.5f, 2.0f)
                curveToRelative(-5.52f, 0.0f, -10.0f, 4.48f, -10.0f, 10.0f)
                reflectiveCurveTo(9.98f, 22.0f, 15.5f, 22.0f)
                lineTo(15.5f, 22.0f)
                close()
            }
        }
        return _nightlightRound!!
    }

private var _nightlightRound: ImageVector? = null
