/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.StarBorderPurple500: ImageVector
    get() {
        if (_starBorderPurple500 != null) {
            return _starBorderPurple500!!
        }
        _starBorderPurple500 = materialIcon(name = "Filled.StarBorderPurple500") {
            materialPath {
                moveTo(12.0f, 8.89f)
                lineTo(12.94f, 12.0f)
                horizontalLineToRelative(2.82f)
                lineToRelative(-2.27f, 1.62f)
                lineToRelative(0.93f, 3.01f)
                lineTo(12.0f, 14.79f)
                lineToRelative(-2.42f, 1.84f)
                lineToRelative(0.93f, -3.01f)
                lineTo(8.24f, 12.0f)
                horizontalLineToRelative(2.82f)
                lineTo(12.0f, 8.89f)
                moveTo(12.0f, 2.0f)
                lineToRelative(-2.42f, 8.0f)
                horizontalLineTo(2.0f)
                lineToRelative(6.17f, 4.41f)
                lineTo(5.83f, 22.0f)
                lineTo(12.0f, 17.31f)
                lineTo(18.18f, 22.0f)
                lineToRelative(-2.35f, -7.59f)
                lineTo(22.0f, 10.0f)
                horizontalLineToRelative(-7.58f)
                lineTo(12.0f, 2.0f)
                lineTo(12.0f, 2.0f)
                close()
            }
        }
        return _starBorderPurple500!!
    }

private var _starBorderPurple500: ImageVector? = null
