/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Motorcycle: ImageVector
    get() {
        if (_motorcycle != null) {
            return _motorcycle!!
        }
        _motorcycle = materialIcon(name = "Filled.Motorcycle") {
            materialPath {
                moveTo(17.5f, 10.0f)
                curveToRelative(-0.03f, 0.0f, -0.05f, 0.01f, -0.08f, 0.01f)
                lineTo(13.41f, 6.0f)
                lineTo(9.0f, 6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.59f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineToRelative(-8.1f)
                curveTo(4.01f, 10.0f, 2.0f, 12.02f, 2.0f, 14.5f)
                curveTo(2.0f, 16.99f, 4.01f, 19.0f, 6.5f, 19.0f)
                curveToRelative(2.22f, 0.0f, 4.06f, -1.62f, 4.42f, -3.73f)
                lineTo(13.04f, 14.0f)
                curveToRelative(-0.02f, 0.17f, -0.04f, 0.33f, -0.04f, 0.5f)
                curveToRelative(0.0f, 2.49f, 2.01f, 4.5f, 4.5f, 4.5f)
                reflectiveCurveToRelative(4.5f, -2.01f, 4.5f, -4.5f)
                reflectiveCurveToRelative(-2.01f, -4.5f, -4.5f, -4.5f)
                close()
                moveTo(8.84f, 15.26f)
                curveTo(8.52f, 16.27f, 7.58f, 17.0f, 6.47f, 17.0f)
                curveToRelative(-1.38f, 0.0f, -2.5f, -1.12f, -2.5f, -2.5f)
                reflectiveCurveTo(5.09f, 12.0f, 6.47f, 12.0f)
                curveToRelative(1.12f, 0.0f, 2.05f, 0.74f, 2.37f, 1.75f)
                lineTo(6.0f, 13.75f)
                verticalLineToRelative(1.5f)
                lineToRelative(2.84f, 0.01f)
                close()
                moveTo(17.47f, 17.0f)
                curveToRelative(-1.38f, 0.0f, -2.5f, -1.12f, -2.5f, -2.5f)
                reflectiveCurveToRelative(1.12f, -2.5f, 2.5f, -2.5f)
                reflectiveCurveToRelative(2.5f, 1.12f, 2.5f, 2.5f)
                reflectiveCurveToRelative(-1.12f, 2.5f, -2.5f, 2.5f)
                close()
            }
        }
        return _motorcycle!!
    }

private var _motorcycle: ImageVector? = null
