/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.WatchOff: ImageVector
    get() {
        if (_watchOff != null) {
            return _watchOff!!
        }
        _watchOff = materialIcon(name = "TwoTone.WatchOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.89f, 5.27f)
                lineTo(13.51f, 4.0f)
                horizontalLineToRelative(-3.02f)
                lineToRelative(-0.38f, 1.27f)
                curveTo(11.93f, 4.76f, 13.34f, 5.11f, 13.89f, 5.27f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.11f, 18.73f)
                lineTo(10.49f, 20.0f)
                horizontalLineToRelative(3.02f)
                lineToRelative(0.38f, -1.27f)
                curveTo(12.07f, 19.24f, 10.66f, 18.89f, 10.11f, 18.73f)
                close()
            }
            materialPath {
                moveTo(12.0f, 7.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                curveToRelative(0.0f, 0.64f, -0.13f, 1.25f, -0.35f, 1.82f)
                lineToRelative(1.5f, 1.5f)
                curveTo(18.69f, 14.33f, 19.0f, 13.2f, 19.0f, 12.0f)
                curveToRelative(0.0f, -2.22f, -1.03f, -4.19f, -2.64f, -5.47f)
                lineTo(15.0f, 2.0f)
                horizontalLineTo(9.0f)
                lineTo(8.04f, 5.21f)
                lineToRelative(2.14f, 2.14f)
                curveTo(10.75f, 7.13f, 11.36f, 7.0f, 12.0f, 7.0f)
                close()
                moveTo(10.49f, 4.0f)
                horizontalLineToRelative(3.02f)
                lineToRelative(0.38f, 1.27f)
                curveToRelative(-0.55f, -0.16f, -1.97f, -0.51f, -3.78f, 0.0f)
                lineTo(10.49f, 4.0f)
                close()
            }
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(4.46f, 4.46f)
                curveTo(5.31f, 9.67f, 5.0f, 10.8f, 5.0f, 12.0f)
                curveToRelative(0.0f, 2.22f, 1.03f, 4.19f, 2.64f, 5.47f)
                lineTo(9.0f, 22.0f)
                horizontalLineToRelative(6.0f)
                lineToRelative(0.96f, -3.21f)
                lineToRelative(3.82f, 3.82f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(13.51f, 20.0f)
                horizontalLineToRelative(-3.02f)
                lineToRelative(-0.38f, -1.27f)
                curveToRelative(0.55f, 0.15f, 1.97f, 0.51f, 3.78f, 0.0f)
                lineTo(13.51f, 20.0f)
                close()
                moveTo(12.0f, 17.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                curveToRelative(0.0f, -0.64f, 0.13f, -1.25f, 0.35f, -1.82f)
                lineToRelative(6.47f, 6.47f)
                curveTo(13.25f, 16.87f, 12.64f, 17.0f, 12.0f, 17.0f)
                close()
            }
        }
        return _watchOff!!
    }

private var _watchOff: ImageVector? = null
