/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Tungsten: ImageVector
    get() {
        if (_tungsten != null) {
            return _tungsten!!
        }
        _tungsten = materialIcon(name = "TwoTone.Tungsten") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 7.1f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.1f)
                curveTo(11.32f, 7.04f, 11.66f, 7.0f, 12.0f, 7.0f)
                reflectiveCurveTo(12.68f, 7.04f, 13.0f, 7.1f)
                close()
            }
            materialPath {
                moveTo(11.0f, 19.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(2.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 11.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
            materialPath {
                moveTo(15.894f, 17.801f)
                lineToRelative(1.407f, -1.407f)
                lineToRelative(2.121f, 2.121f)
                lineToRelative(-1.407f, 1.407f)
                close()
            }
            materialPath {
                moveTo(4.584f, 18.509f)
                lineToRelative(2.121f, -2.121f)
                lineToRelative(1.407f, 1.407f)
                lineToRelative(-2.121f, 2.121f)
                close()
            }
            materialPath {
                moveTo(15.0f, 8.02f)
                verticalLineTo(3.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(5.02f)
                curveTo(7.79f, 8.94f, 7.0f, 10.37f, 7.0f, 12.0f)
                curveToRelative(0.0f, 2.76f, 2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                curveTo(17.0f, 10.37f, 16.21f, 8.94f, 15.0f, 8.02f)
                close()
                moveTo(11.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.1f)
                curveTo(12.68f, 7.04f, 12.34f, 7.0f, 12.0f, 7.0f)
                reflectiveCurveToRelative(-0.68f, 0.04f, -1.0f, 0.1f)
                verticalLineTo(5.0f)
                close()
                moveTo(12.0f, 15.0f)
                curveToRelative(-1.65f, 0.0f, -3.0f, -1.35f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.35f, -3.0f, 3.0f, -3.0f)
                curveToRelative(1.65f, 0.0f, 3.0f, 1.35f, 3.0f, 3.0f)
                reflectiveCurveTo(13.65f, 15.0f, 12.0f, 15.0f)
                close()
            }
        }
        return _tungsten!!
    }

private var _tungsten: ImageVector? = null
