/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Score: ImageVector
    get() {
        if (_score != null) {
            return _score!!
        }
        _score = materialIcon(name = "TwoTone.Score") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 19.0f)
                horizontalLineToRelative(8.0f)
                lineToRelative(-4.0f, -4.0f)
                close()
                moveTo(5.0f, 16.5f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(6.0f, -6.0f)
                lineTo(19.0f, 5.0f)
                lineTo(5.0f, 5.0f)
                verticalLineToRelative(11.5f)
                close()
                moveTo(12.0f, 6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.0f, -3.0f)
                horizontalLineToRelative(1.7f)
                lineToRelative(-2.0f, 3.0f)
                lineToRelative(2.0f, 3.0f)
                horizontalLineToRelative(-1.7f)
                lineToRelative(-2.0f, -3.0f)
                verticalLineToRelative(3.0f)
                lineTo(12.0f, 12.0f)
                lineTo(12.0f, 6.0f)
                close()
                moveTo(7.0f, 8.25f)
                horizontalLineToRelative(2.5f)
                lineTo(9.5f, 7.5f)
                lineTo(7.0f, 7.5f)
                lineTo(7.0f, 6.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(3.75f)
                lineTo(8.5f, 9.75f)
                verticalLineToRelative(0.75f)
                lineTo(11.0f, 10.5f)
                lineTo(11.0f, 12.0f)
                lineTo(7.0f, 12.0f)
                lineTo(7.0f, 8.25f)
                close()
                moveTo(19.0f, 19.0f)
                verticalLineToRelative(-6.0f)
                lineToRelative(-6.0f, 6.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                lineTo(5.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(19.0f, 19.0f)
                lineTo(5.0f, 19.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(6.0f, -6.0f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(19.0f, 10.5f)
                lineToRelative(-6.0f, 6.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-4.0f, 4.0f)
                lineTo(5.0f, 5.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(5.5f)
                close()
                moveTo(13.5f, 9.0f)
                lineTo(13.5f, 6.0f)
                lineTo(12.0f, 6.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                close()
                moveTo(17.2f, 12.0f)
                lineToRelative(-2.0f, -3.0f)
                lineToRelative(2.0f, -3.0f)
                horizontalLineToRelative(-1.7f)
                lineToRelative(-2.0f, 3.0f)
                lineToRelative(2.0f, 3.0f)
                close()
                moveTo(11.0f, 10.5f)
                lineTo(8.5f, 10.5f)
                verticalLineToRelative(-0.75f)
                lineTo(11.0f, 9.75f)
                lineTo(11.0f, 6.0f)
                lineTo(7.0f, 6.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(2.5f)
                verticalLineToRelative(0.75f)
                lineTo(7.0f, 8.25f)
                lineTo(7.0f, 12.0f)
                horizontalLineToRelative(4.0f)
                close()
            }
        }
        return _score!!
    }

private var _score: ImageVector? = null
