/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.RoundaboutLeft: ImageVector
    get() {
        if (_roundaboutLeft != null) {
            return _roundaboutLeft!!
        }
        _roundaboutLeft = materialIcon(name = "TwoTone.RoundaboutLeft") {
            materialPath {
                moveTo(10.08f, 8.0f)
                curveToRelative(0.48f, -2.84f, 2.94f, -5.0f, 5.92f, -5.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, 2.69f, 6.0f, 6.0f)
                curveToRelative(0.0f, 2.97f, -2.16f, 5.44f, -5.0f, 5.92f)
                lineTo(17.0f, 21.0f)
                horizontalLineToRelative(-2.0f)
                lineToRelative(0.0f, -6.09f)
                curveToRelative(0.0f, -0.98f, 0.71f, -1.8f, 1.67f, -1.97f)
                curveTo(18.56f, 12.63f, 20.0f, 10.98f, 20.0f, 9.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                curveToRelative(-1.98f, 0.0f, -3.63f, 1.44f, -3.94f, 3.33f)
                curveTo(11.89f, 9.29f, 11.07f, 10.0f, 10.09f, 10.0f)
                lineToRelative(-4.26f, 0.0f)
                lineToRelative(1.59f, 1.59f)
                lineTo(6.0f, 13.0f)
                lineTo(2.0f, 9.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(1.41f, 1.41f)
                lineTo(5.83f, 8.0f)
                lineTo(10.08f, 8.0f)
                close()
            }
        }
        return _roundaboutLeft!!
    }

private var _roundaboutLeft: ImageVector? = null
