/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PsychologyAlt: ImageVector
    get() {
        if (_psychologyAlt != null) {
            return _psychologyAlt!!
        }
        _psychologyAlt = materialIcon(name = "TwoTone.PsychologyAlt") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 5.0f)
                curveToRelative(-2.65f, 0.0f, -4.79f, 2.06f, -4.97f, 4.67f)
                lineTo(6.7f, 12.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-3.95f)
                lineToRelative(0.89f, -0.42f)
                curveTo(16.71f, 13.88f, 18.0f, 12.09f, 18.0f, 10.0f)
                curveTo(18.0f, 7.24f, 15.76f, 5.0f, 13.0f, 5.0f)
                close()
                moveTo(12.5f, 14.0f)
                curveToRelative(-0.41f, 0.0f, -0.74f, -0.33f, -0.74f, -0.74f)
                curveToRelative(0.0f, -0.41f, 0.33f, -0.73f, 0.74f, -0.73f)
                curveToRelative(0.41f, 0.0f, 0.73f, 0.32f, 0.73f, 0.73f)
                curveTo(13.23f, 13.67f, 12.92f, 14.0f, 12.5f, 14.0f)
                close()
                moveTo(14.26f, 9.68f)
                curveToRelative(-0.44f, 0.65f, -0.86f, 0.85f, -1.09f, 1.27f)
                curveToRelative(-0.09f, 0.17f, -0.13f, 0.28f, -0.13f, 0.82f)
                horizontalLineToRelative(-1.06f)
                curveToRelative(0.0f, -0.29f, -0.04f, -0.75f, 0.18f, -1.16f)
                curveToRelative(0.28f, -0.51f, 0.83f, -0.81f, 1.14f, -1.26f)
                curveToRelative(0.33f, -0.47f, 0.15f, -1.36f, -0.8f, -1.36f)
                curveToRelative(-0.62f, 0.0f, -0.92f, 0.47f, -1.05f, 0.86f)
                lineToRelative(-0.96f, -0.4f)
                curveTo(10.76f, 7.67f, 11.46f, 7.0f, 12.5f, 7.0f)
                curveToRelative(0.86f, 0.0f, 1.45f, 0.39f, 1.75f, 0.88f)
                curveTo(14.51f, 8.31f, 14.66f, 9.1f, 14.26f, 9.68f)
                close()
            }
            materialPath {
                moveTo(19.94f, 9.06f)
                curveTo(19.5f, 5.73f, 16.57f, 3.0f, 13.0f, 3.0f)
                curveTo(9.47f, 3.0f, 6.57f, 5.61f, 6.08f, 9.0f)
                lineToRelative(-1.93f, 3.48f)
                curveTo(3.74f, 13.14f, 4.22f, 14.0f, 5.0f, 14.0f)
                horizontalLineToRelative(1.0f)
                lineToRelative(0.0f, 2.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(7.0f)
                lineToRelative(0.0f, -4.68f)
                curveTo(18.62f, 15.07f, 20.35f, 12.24f, 19.94f, 9.06f)
                close()
                moveTo(14.89f, 14.63f)
                lineTo(14.0f, 15.05f)
                verticalLineTo(19.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(6.7f)
                lineToRelative(1.33f, -2.33f)
                curveTo(8.21f, 7.06f, 10.35f, 5.0f, 13.0f, 5.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                curveTo(18.0f, 12.09f, 16.71f, 13.88f, 14.89f, 14.63f)
                close()
            }
            materialPath {
                moveTo(12.5f, 12.54f)
                curveToRelative(-0.41f, 0.0f, -0.74f, 0.31f, -0.74f, 0.73f)
                curveToRelative(0.0f, 0.41f, 0.33f, 0.74f, 0.74f, 0.74f)
                curveToRelative(0.42f, 0.0f, 0.73f, -0.33f, 0.73f, -0.74f)
                curveTo(13.23f, 12.85f, 12.92f, 12.54f, 12.5f, 12.54f)
                close()
            }
            materialPath {
                moveTo(12.5f, 7.0f)
                curveToRelative(-1.03f, 0.0f, -1.74f, 0.67f, -2.0f, 1.45f)
                lineToRelative(0.96f, 0.4f)
                curveToRelative(0.13f, -0.39f, 0.43f, -0.86f, 1.05f, -0.86f)
                curveToRelative(0.95f, 0.0f, 1.13f, 0.89f, 0.8f, 1.36f)
                curveToRelative(-0.32f, 0.45f, -0.86f, 0.75f, -1.14f, 1.26f)
                curveToRelative(-0.23f, 0.4f, -0.18f, 0.87f, -0.18f, 1.16f)
                horizontalLineToRelative(1.06f)
                curveToRelative(0.0f, -0.55f, 0.04f, -0.65f, 0.13f, -0.82f)
                curveToRelative(0.23f, -0.42f, 0.65f, -0.62f, 1.09f, -1.27f)
                curveToRelative(0.4f, -0.59f, 0.25f, -1.38f, -0.01f, -1.8f)
                curveTo(13.95f, 7.39f, 13.36f, 7.0f, 12.5f, 7.0f)
                close()
            }
        }
        return _psychologyAlt!!
    }

private var _psychologyAlt: ImageVector? = null
