/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.NetworkWifi2Bar: ImageVector
    get() {
        if (_networkWifi2Bar != null) {
            return _networkWifi2Bar!!
        }
        _networkWifi2Bar = materialIcon(name = "TwoTone.NetworkWifi2Bar") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.78f, 13.38f)
                curveTo(15.4f, 12.5f, 13.76f, 12.0f, 12.0f, 12.0f)
                curveToRelative(-1.76f, 0.0f, -3.4f, 0.5f, -4.78f, 1.38f)
                lineToRelative(-4.3f, -4.3f)
                curveTo(5.51f, 7.08f, 8.67f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveToRelative(6.49f, 1.08f, 9.08f, 3.07f)
                lineTo(16.78f, 13.38f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                curveTo(7.31f, 4.0f, 3.07f, 5.9f, 0.0f, 8.98f)
                lineTo(12.0f, 21.0f)
                lineTo(24.0f, 8.98f)
                curveTo(20.93f, 5.9f, 16.69f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(16.78f, 13.38f)
                curveTo(15.4f, 12.5f, 13.76f, 12.0f, 12.0f, 12.0f)
                curveToRelative(-1.76f, 0.0f, -3.4f, 0.5f, -4.78f, 1.38f)
                lineToRelative(-4.3f, -4.3f)
                curveTo(5.51f, 7.08f, 8.67f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveToRelative(6.49f, 1.08f, 9.08f, 3.07f)
                lineTo(16.78f, 13.38f)
                close()
            }
        }
        return _networkWifi2Bar!!
    }

private var _networkWifi2Bar: ImageVector? = null
