/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Looks: ImageVector
    get() {
        if (_looks != null) {
            return _looks!!
        }
        _looks = materialIcon(name = "TwoTone.Looks") {
            materialPath {
                moveTo(12.0f, 6.0f)
                curveTo(5.93f, 6.0f, 1.0f, 10.93f, 1.0f, 17.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -4.96f, 4.04f, -9.0f, 9.0f, -9.0f)
                reflectiveCurveToRelative(9.0f, 4.04f, 9.0f, 9.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -6.07f, -4.93f, -11.0f, -11.0f, -11.0f)
                close()
                moveTo(12.0f, 12.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -3.86f, -3.14f, -7.0f, -7.0f, -7.0f)
                reflectiveCurveToRelative(-7.0f, 3.14f, -7.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -2.76f, 2.24f, -5.0f, 5.0f, -5.0f)
                close()
            }
        }
        return _looks!!
    }

private var _looks: ImageVector? = null
