/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.LayersClear: ImageVector
    get() {
        if (_layersClear != null) {
            return _layersClear!!
        }
        _layersClear = materialIcon(name = "TwoTone.LayersClear") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 13.47f)
                lineToRelative(0.67f, -0.53f)
                lineToRelative(-5.02f, -5.02f)
                lineTo(6.26f, 9.0f)
                close()
                moveTo(12.0f, 4.53f)
                lineToRelative(-1.17f, 0.91f)
                lineToRelative(5.02f, 5.03f)
                lineTo(17.74f, 9.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.53f)
                lineTo(17.74f, 9.0f)
                lineToRelative(-1.89f, 1.47f)
                lineToRelative(1.43f, 1.42f)
                lineTo(21.0f, 9.0f)
                lineToRelative(-9.0f, -7.0f)
                lineToRelative(-2.59f, 2.02f)
                lineToRelative(1.42f, 1.42f)
                close()
                moveTo(21.0f, 14.07f)
                lineToRelative(-1.63f, -1.27f)
                lineToRelative(-0.67f, 0.52f)
                lineToRelative(1.43f, 1.43f)
                close()
                moveTo(3.41f, 0.86f)
                lineTo(2.0f, 2.27f)
                lineToRelative(4.22f, 4.22f)
                lineTo(3.0f, 9.0f)
                lineToRelative(9.0f, 7.0f)
                lineToRelative(2.1f, -1.63f)
                lineToRelative(1.42f, 1.42f)
                lineToRelative(-3.53f, 2.75f)
                lineToRelative(-7.37f, -5.73f)
                lineTo(3.0f, 14.07f)
                lineToRelative(9.0f, 7.0f)
                lineToRelative(4.95f, -3.85f)
                lineTo(20.73f, 21.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(3.41f, 0.86f)
                close()
                moveTo(12.0f, 13.47f)
                lineTo(6.26f, 9.0f)
                lineToRelative(1.39f, -1.08f)
                lineToRelative(5.02f, 5.02f)
                lineToRelative(-0.67f, 0.53f)
                close()
            }
        }
        return _layersClear!!
    }

private var _layersClear: ImageVector? = null
