/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FolderCopy: ImageVector
    get() {
        if (_folderCopy != null) {
            return _folderCopy!!
        }
        _folderCopy = materialIcon(name = "TwoTone.FolderCopy") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.17f, 4.0f)
                lineToRelative(-4.17f, 0.0f)
                lineToRelative(0.0f, 11.0f)
                lineToRelative(14.0f, 0.0f)
                lineToRelative(0.0f, -9.0f)
                lineToRelative(-7.83f, 0.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 4.0f)
                horizontalLineToRelative(-7.0f)
                lineToRelative(-2.0f, -2.0f)
                horizontalLineTo(7.0f)
                curveTo(5.9f, 2.0f, 5.01f, 2.9f, 5.01f, 4.0f)
                lineTo(5.0f, 15.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(23.0f, 4.9f, 22.1f, 4.0f, 21.0f, 4.0f)
                close()
                moveTo(21.0f, 15.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(4.17f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineTo(21.0f)
                verticalLineTo(15.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 6.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(13.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(17.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(6.0f)
                close()
            }
        }
        return _folderCopy!!
    }

private var _folderCopy: ImageVector? = null
