/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.DirectionsOff: ImageVector
    get() {
        if (_directionsOff != null) {
            return _directionsOff!!
        }
        _directionsOff = materialIcon(name = "TwoTone.DirectionsOff") {
            materialPath {
                moveTo(21.71f, 11.29f)
                lineToRelative(-9.0f, -9.0f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(8.21f, 5.38f)
                lineToRelative(1.41f, 1.41f)
                lineTo(12.0f, 4.42f)
                lineTo(19.58f, 12.0f)
                lineToRelative(-2.38f, 2.38f)
                lineToRelative(1.41f, 1.41f)
                lineToRelative(3.09f, -3.09f)
                curveTo(22.1f, 12.33f, 22.1f, 11.7f, 21.71f, 11.29f)
                close()
            }
            materialPath {
                moveTo(13.0f, 7.5f)
                lineToRelative(0.0f, 2.67f)
                lineToRelative(2.17f, 2.17f)
                lineToRelative(1.33f, -1.34f)
                close()
            }
            materialPath {
                moveTo(1.39f, 4.22f)
                lineToRelative(3.99f, 3.99f)
                lineToRelative(-3.09f, 3.09f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(9.0f, 9.0f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(3.09f, -3.09f)
                lineToRelative(3.99f, 3.99f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                close()
                moveTo(8.03f, 10.85f)
                curveTo(8.02f, 10.9f, 7.99f, 10.95f, 7.99f, 11.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.18f)
                lineToRelative(4.38f, 4.38f)
                lineTo(12.0f, 19.58f)
                lineTo(4.42f, 12.0f)
                lineToRelative(2.38f, -2.38f)
                lineTo(8.03f, 10.85f)
                close()
            }
        }
        return _directionsOff!!
    }

private var _directionsOff: ImageVector? = null
