/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Diamond: ImageVector
    get() {
        if (_diamond != null) {
            return _diamond!!
        }
        _diamond = materialIcon(name = "TwoTone.Diamond") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(8.88f, 5.0f)
                lineToRelative(-2.64f, 0.0f)
                lineToRelative(-1.5f, 3.0f)
                lineToRelative(2.64f, 0.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.26f, 8.0f)
                lineToRelative(-1.5f, -3.0f)
                lineToRelative(-2.64f, 0.0f)
                lineToRelative(1.5f, 3.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.0f, 16.68f)
                lineToRelative(0.0f, -6.68f)
                lineToRelative(-5.56f, 0.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 16.68f)
                lineToRelative(5.56f, -6.68f)
                lineToRelative(-5.56f, 0.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.88f, 5.0f)
                lineToRelative(-1.76f, 0.0f)
                lineToRelative(-1.5f, 3.0f)
                lineToRelative(4.76f, 0.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineTo(5.0f)
                lineTo(2.0f, 9.0f)
                lineToRelative(10.0f, 12.0f)
                lineTo(22.0f, 9.0f)
                lineTo(19.0f, 3.0f)
                close()
                moveTo(17.76f, 5.0f)
                lineToRelative(1.5f, 3.0f)
                horizontalLineToRelative(-2.65f)
                lineToRelative(-1.5f, -3.0f)
                horizontalLineTo(17.76f)
                close()
                moveTo(6.24f, 5.0f)
                horizontalLineToRelative(2.65f)
                lineToRelative(-1.5f, 3.0f)
                horizontalLineTo(4.74f)
                lineTo(6.24f, 5.0f)
                close()
                moveTo(11.0f, 16.68f)
                lineTo(5.44f, 10.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(16.68f)
                close()
                moveTo(9.62f, 8.0f)
                lineToRelative(1.5f, -3.0f)
                horizontalLineToRelative(1.76f)
                lineToRelative(1.5f, 3.0f)
                horizontalLineTo(9.62f)
                close()
                moveTo(13.0f, 16.68f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(5.56f)
                lineTo(13.0f, 16.68f)
                close()
            }
        }
        return _diamond!!
    }

private var _diamond: ImageVector? = null
