/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.DeviceUnknown: ImageVector
    get() {
        if (_deviceUnknown != null) {
            return _deviceUnknown!!
        }
        _deviceUnknown = materialIcon(name = "TwoTone.DeviceUnknown") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(7.0f, 19.0f)
                horizontalLineToRelative(10.0f)
                lineTo(17.0f, 5.0f)
                lineTo(7.0f, 5.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(13.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                close()
                moveTo(12.0f, 6.72f)
                curveToRelative(1.96f, 0.0f, 3.5f, 1.51f, 3.5f, 3.47f)
                curveToRelative(0.0f, 2.26f, -2.62f, 2.49f, -2.62f, 4.45f)
                horizontalLineToRelative(-1.76f)
                curveToRelative(0.0f, -2.88f, 2.63f, -2.7f, 2.63f, -4.45f)
                curveToRelative(0.0f, -0.93f, -0.82f, -1.75f, -1.75f, -1.75f)
                reflectiveCurveToRelative(-1.75f, 0.82f, -1.75f, 1.75f)
                lineTo(8.5f, 10.19f)
                curveToRelative(0.0f, -1.95f, 1.54f, -3.47f, 3.5f, -3.47f)
                close()
            }
            materialPath {
                moveTo(11.0f, 16.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                close()
                moveTo(17.0f, 1.0f)
                lineTo(7.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(19.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(17.0f, 19.0f)
                lineTo(7.0f, 19.0f)
                lineTo(7.0f, 5.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(12.0f, 8.44f)
                curveToRelative(0.93f, 0.0f, 1.75f, 0.82f, 1.75f, 1.75f)
                curveToRelative(0.0f, 1.75f, -2.63f, 1.57f, -2.63f, 4.45f)
                horizontalLineToRelative(1.76f)
                curveToRelative(0.0f, -1.96f, 2.62f, -2.19f, 2.62f, -4.45f)
                curveToRelative(0.0f, -1.96f, -1.54f, -3.47f, -3.5f, -3.47f)
                reflectiveCurveToRelative(-3.5f, 1.52f, -3.5f, 3.47f)
                horizontalLineToRelative(1.75f)
                curveToRelative(0.0f, -0.93f, 0.82f, -1.75f, 1.75f, -1.75f)
                close()
            }
        }
        return _deviceUnknown!!
    }

private var _deviceUnknown: ImageVector? = null
