/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.BluetoothDrive: ImageVector
    get() {
        if (_bluetoothDrive != null) {
            return _bluetoothDrive!!
        }
        _bluetoothDrive = materialIcon(name = "TwoTone.BluetoothDrive") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 17.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(-1.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(17.0f)
                close()
                moveTo(15.5f, 13.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(16.33f, 16.0f, 15.5f, 16.0f)
                reflectiveCurveTo(14.0f, 15.33f, 14.0f, 14.5f)
                reflectiveCurveTo(14.67f, 13.0f, 15.5f, 13.0f)
                close()
                moveTo(6.5f, 13.0f)
                curveTo(7.33f, 13.0f, 8.0f, 13.67f, 8.0f, 14.5f)
                reflectiveCurveTo(7.33f, 16.0f, 6.5f, 16.0f)
                reflectiveCurveTo(5.0f, 15.33f, 5.0f, 14.5f)
                reflectiveCurveTo(5.67f, 13.0f, 6.5f, 13.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 17.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(13.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                horizontalLineTo(4.81f)
                lineToRelative(1.04f, -3.0f)
                horizontalLineTo(15.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(5.5f)
                curveTo(4.84f, 5.0f, 4.29f, 5.42f, 4.08f, 6.01f)
                lineTo(2.0f, 12.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(17.0f)
                close()
            }
            materialPath {
                moveTo(6.5f, 14.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(15.5f, 14.5f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(22.0f, 3.85f)
                lineTo(19.15f, 1.0f)
                horizontalLineToRelative(-0.5f)
                verticalLineToRelative(3.79f)
                lineToRelative(-2.3f, -2.29f)
                lineToRelative(-0.7f, 0.7f)
                lineTo(18.44f, 6.0f)
                lineToRelative(-2.79f, 2.79f)
                lineToRelative(0.7f, 0.71f)
                lineToRelative(2.3f, -2.3f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(0.5f)
                lineTo(22.0f, 8.14f)
                lineTo(19.85f, 6.0f)
                lineTo(22.0f, 3.85f)
                close()
                moveTo(19.65f, 2.91f)
                lineToRelative(0.94f, 0.94f)
                lineToRelative(-0.94f, 0.94f)
                verticalLineTo(2.91f)
                close()
                moveTo(20.59f, 8.14f)
                lineToRelative(-0.94f, 0.94f)
                verticalLineTo(7.2f)
                lineTo(20.59f, 8.14f)
                close()
            }
        }
        return _bluetoothDrive!!
    }

private var _bluetoothDrive: ImageVector? = null
