/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Attractions: ImageVector
    get() {
        if (_attractions != null) {
            return _attractions!!
        }
        _attractions = materialIcon(name = "TwoTone.Attractions") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(11.98f, 12.02f)
                moveToRelative(-1.5f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, 3.0f, 0.0f)
                arcToRelative(1.5f, 1.5f, 0.0f, true, true, -3.0f, 0.0f)
            }
            materialPath {
                moveTo(20.15f, 14.42f)
                curveToRelative(0.23f, -0.77f, 0.35f, -1.58f, 0.35f, -2.42f)
                reflectiveCurveToRelative(-0.12f, -1.65f, -0.35f, -2.42f)
                curveToRelative(0.78f, -0.6f, 1.02f, -1.7f, 0.51f, -2.58f)
                curveToRelative(-0.51f, -0.88f, -1.58f, -1.23f, -2.49f, -0.85f)
                curveToRelative(-1.11f, -1.17f, -2.56f, -2.03f, -4.18f, -2.42f)
                curveTo(13.85f, 2.75f, 13.01f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveToRelative(-1.85f, 0.75f, -1.98f, 1.73f)
                curveTo(8.39f, 4.12f, 6.95f, 4.98f, 5.83f, 6.15f)
                curveTo(4.92f, 5.77f, 3.85f, 6.12f, 3.34f, 7.0f)
                curveTo(2.83f, 7.88f, 3.07f, 8.98f, 3.85f, 9.58f)
                curveTo(3.62f, 10.35f, 3.5f, 11.16f, 3.5f, 12.0f)
                reflectiveCurveToRelative(0.12f, 1.65f, 0.35f, 2.42f)
                curveToRelative(-0.78f, 0.6f, -1.02f, 1.7f, -0.51f, 2.58f)
                curveToRelative(0.51f, 0.88f, 1.58f, 1.23f, 2.49f, 0.85f)
                curveToRelative(0.4f, 0.42f, 0.83f, 0.79f, 1.3f, 1.12f)
                lineTo(5.78f, 22.0f)
                horizontalLineToRelative(1.88f)
                lineToRelative(0.98f, -2.19f)
                curveToRelative(0.44f, 0.19f, 0.9f, 0.34f, 1.38f, 0.46f)
                curveTo(10.15f, 21.25f, 10.99f, 22.0f, 12.0f, 22.0f)
                reflectiveCurveToRelative(1.85f, -0.75f, 1.98f, -1.73f)
                curveToRelative(0.46f, -0.11f, 0.91f, -0.26f, 1.34f, -0.44f)
                lineTo(16.3f, 22.0f)
                horizontalLineToRelative(1.88f)
                lineToRelative(-1.34f, -3.0f)
                curveToRelative(0.48f, -0.34f, 0.93f, -0.72f, 1.34f, -1.15f)
                curveToRelative(0.91f, 0.38f, 1.99f, 0.03f, 2.49f, -0.85f)
                reflectiveCurveTo(20.93f, 15.02f, 20.15f, 14.42f)
                close()
                moveTo(13.56f, 18.75f)
                curveTo(13.19f, 18.29f, 12.63f, 18.0f, 12.0f, 18.0f)
                reflectiveCurveToRelative(-1.2f, 0.29f, -1.57f, 0.75f)
                curveToRelative(-0.4f, -0.09f, -0.79f, -0.21f, -1.16f, -0.37f)
                lineToRelative(1.43f, -3.19f)
                curveToRelative(0.4f, 0.16f, 0.84f, 0.25f, 1.3f, 0.25f)
                curveToRelative(0.44f, 0.0f, 0.87f, -0.08f, 1.26f, -0.23f)
                lineToRelative(1.42f, 3.18f)
                curveTo(14.32f, 18.54f, 13.95f, 18.66f, 13.56f, 18.75f)
                close()
                moveTo(10.48f, 12.02f)
                curveToRelative(0.0f, -0.83f, 0.67f, -1.5f, 1.5f, -1.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                curveTo(11.15f, 13.52f, 10.48f, 12.85f, 10.48f, 12.02f)
                close()
                moveTo(18.71f, 14.01f)
                curveToRelative(-0.61f, 0.07f, -1.18f, 0.41f, -1.52f, 0.99f)
                curveToRelative(-0.32f, 0.56f, -0.34f, 1.2f, -0.12f, 1.75f)
                curveToRelative(-0.28f, 0.29f, -0.58f, 0.55f, -0.9f, 0.79f)
                lineToRelative(-1.5f, -3.35f)
                curveToRelative(0.49f, -0.59f, 0.78f, -1.34f, 0.78f, -2.16f)
                curveToRelative(0.0f, -1.89f, -1.55f, -3.41f, -3.46f, -3.41f)
                curveToRelative(-1.91f, 0.0f, -3.46f, 1.53f, -3.46f, 3.41f)
                curveToRelative(0.0f, 0.8f, 0.28f, 1.54f, 0.75f, 2.13f)
                lineToRelative(-1.52f, 3.39f)
                curveToRelative(-0.31f, -0.23f, -0.6f, -0.48f, -0.87f, -0.76f)
                curveTo(7.15f, 16.23f, 7.13f, 15.57f, 6.8f, 15.0f)
                curveToRelative(-0.34f, -0.59f, -0.93f, -0.94f, -1.56f, -0.99f)
                curveToRelative(-0.22f, -0.68f, -0.33f, -1.4f, -0.33f, -2.15f)
                curveToRelative(0.0f, -0.64f, 0.09f, -1.26f, 0.25f, -1.85f)
                curveToRelative(0.66f, -0.03f, 1.3f, -0.38f, 1.65f, -1.0f)
                curveToRelative(0.37f, -0.63f, 0.35f, -1.38f, 0.01f, -1.98f)
                curveTo(7.74f, 6.05f, 8.93f, 5.34f, 10.27f, 5.0f)
                curveToRelative(0.34f, 0.59f, 0.99f, 1.0f, 1.73f, 1.0f)
                reflectiveCurveToRelative(1.39f, -0.4f, 1.73f, -1.0f)
                curveToRelative(1.34f, 0.34f, 2.53f, 1.07f, 3.44f, 2.05f)
                curveTo(16.85f, 7.64f, 16.84f, 8.38f, 17.2f, 9.0f)
                curveToRelative(0.35f, 0.6f, 0.96f, 0.95f, 1.6f, 1.0f)
                curveToRelative(0.16f, 0.59f, 0.25f, 1.21f, 0.25f, 1.86f)
                curveTo(19.05f, 12.61f, 18.93f, 13.33f, 18.71f, 14.01f)
                close()
            }
        }
        return _attractions!!
    }

private var _attractions: ImageVector? = null
