/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AlarmOff: ImageVector
    get() {
        if (_alarmOff != null) {
            return _alarmOff!!
        }
        _alarmOff = materialIcon(name = "TwoTone.AlarmOff") {
            materialPath {
                moveTo(10.04f, 6.29f)
                curveTo(10.66f, 6.11f, 11.32f, 6.0f, 12.0f, 6.0f)
                curveToRelative(3.86f, 0.0f, 7.0f, 3.14f, 7.0f, 7.0f)
                curveToRelative(0.0f, 0.68f, -0.11f, 1.34f, -0.29f, 1.96f)
                lineToRelative(1.56f, 1.56f)
                curveToRelative(0.47f, -1.08f, 0.73f, -2.27f, 0.73f, -3.52f)
                curveToRelative(0.0f, -4.97f, -4.03f, -9.0f, -9.0f, -9.0f)
                curveToRelative(-1.25f, 0.0f, -2.44f, 0.26f, -3.53f, 0.72f)
                lineToRelative(1.57f, 1.57f)
                close()
                moveTo(17.337f, 1.81f)
                lineToRelative(4.607f, 3.845f)
                lineToRelative(-1.28f, 1.535f)
                lineToRelative(-4.61f, -3.843f)
                close()
                moveTo(19.24f, 18.32f)
                lineToRelative(-1.43f, -1.43f)
                lineToRelative(-9.7f, -9.7f)
                lineToRelative(-1.43f, -1.43f)
                lineToRelative(-0.74f, -0.74f)
                lineTo(4.52f, 3.6f)
                lineToRelative(-1.5f, -1.5f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(1.37f, 1.37f)
                lineToRelative(-0.92f, 0.77f)
                lineToRelative(1.28f, 1.54f)
                lineToRelative(1.06f, -0.88f)
                lineToRelative(0.8f, 0.8f)
                curveTo(3.83f, 8.69f, 3.0f, 10.75f, 3.0f, 13.0f)
                curveToRelative(0.0f, 4.97f, 4.03f, 9.0f, 9.0f, 9.0f)
                curveToRelative(2.25f, 0.0f, 4.31f, -0.83f, 5.89f, -2.2f)
                lineToRelative(2.1f, 2.1f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-2.16f, -2.17f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-3.86f, 0.0f, -7.0f, -3.14f, -7.0f, -7.0f)
                curveToRelative(0.0f, -1.7f, 0.61f, -3.26f, 1.62f, -4.47f)
                lineToRelative(9.85f, 9.85f)
                curveTo(15.26f, 19.39f, 13.7f, 20.0f, 12.0f, 20.0f)
                close()
                moveTo(7.48f, 3.73f)
                lineToRelative(0.46f, -0.38f)
                lineToRelative(-1.28f, -1.54f)
                lineToRelative(-0.6f, 0.5f)
                close()
            }
        }
        return _alarmOff!!
    }

private var _alarmOff: ImageVector? = null
