/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.YoutubeSearchedFor: ImageVector
    get() {
        if (_youtubeSearchedFor != null) {
            return _youtubeSearchedFor!!
        }
        _youtubeSearchedFor = materialIcon(name = "Sharp.YoutubeSearchedFor") {
            materialPath {
                moveTo(17.01f, 14.0f)
                horizontalLineToRelative(-0.8f)
                lineToRelative(-0.27f, -0.27f)
                curveToRelative(0.98f, -1.14f, 1.57f, -2.61f, 1.57f, -4.23f)
                curveToRelative(0.0f, -3.59f, -2.91f, -6.5f, -6.5f, -6.5f)
                reflectiveCurveToRelative(-6.5f, 3.0f, -6.5f, 6.5f)
                horizontalLineTo(2.0f)
                lineToRelative(3.84f, 4.0f)
                lineToRelative(4.16f, -4.0f)
                horizontalLineTo(6.51f)
                curveTo(6.51f, 7.0f, 8.53f, 5.0f, 11.01f, 5.0f)
                reflectiveCurveToRelative(4.5f, 2.01f, 4.5f, 4.5f)
                curveToRelative(0.0f, 2.48f, -2.02f, 4.5f, -4.5f, 4.5f)
                curveToRelative(-0.65f, 0.0f, -1.26f, -0.14f, -1.82f, -0.38f)
                lineTo(7.71f, 15.1f)
                curveToRelative(0.97f, 0.57f, 2.09f, 0.9f, 3.3f, 0.9f)
                curveToRelative(1.61f, 0.0f, 3.08f, -0.59f, 4.22f, -1.57f)
                lineToRelative(0.27f, 0.27f)
                verticalLineToRelative(0.79f)
                lineToRelative(5.01f, 4.99f)
                lineTo(22.0f, 19.0f)
                lineToRelative(-4.99f, -5.0f)
                close()
            }
        }
        return _youtubeSearchedFor!!
    }

private var _youtubeSearchedFor: ImageVector? = null
