/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Tram: ImageVector
    get() {
        if (_tram != null) {
            return _tram!!
        }
        _tram = materialIcon(name = "Sharp.Tram") {
            materialPath {
                moveTo(13.0f, 5.0f)
                lineToRelative(0.75f, -1.5f)
                lineTo(17.0f, 3.5f)
                lineTo(17.0f, 2.0f)
                lineTo(7.0f, 2.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(4.75f)
                lineTo(11.0f, 5.0f)
                curveToRelative(-3.13f, 0.09f, -6.0f, 0.73f, -6.0f, 3.5f)
                lineTo(5.0f, 17.0f)
                curveToRelative(0.0f, 1.5f, 1.11f, 2.73f, 2.55f, 2.95f)
                lineTo(6.0f, 21.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(2.0f)
                lineToRelative(2.0f, -2.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-0.5f)
                lineToRelative(-1.55f, -1.55f)
                curveTo(17.89f, 19.73f, 19.0f, 18.5f, 19.0f, 17.0f)
                lineTo(19.0f, 8.5f)
                curveToRelative(0.0f, -2.77f, -2.87f, -3.41f, -6.0f, -3.5f)
                close()
                moveTo(12.0f, 18.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                close()
                moveTo(17.0f, 14.0f)
                lineTo(7.0f, 14.0f)
                lineTo(7.0f, 9.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(5.0f)
                close()
            }
        }
        return _tram!!
    }

private var _tram: ImageVector? = null
