/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TableRestaurant: ImageVector
    get() {
        if (_tableRestaurant != null) {
            return _tableRestaurant!!
        }
        _tableRestaurant = materialIcon(name = "Sharp.TableRestaurant") {
            materialPath {
                moveTo(22.33f, 11.0f)
                lineToRelative(-2.0f, -7.0f)
                horizontalLineTo(3.67f)
                lineToRelative(-2.0f, 7.0f)
                horizontalLineTo(5.2f)
                lineTo(4.0f, 20.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(0.67f, -5.0f)
                horizontalLineToRelative(10.67f)
                lineTo(18.0f, 20.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(-1.2f, -9.0f)
                horizontalLineTo(22.33f)
                close()
                moveTo(6.93f, 13.0f)
                lineToRelative(0.27f, -2.0f)
                horizontalLineToRelative(9.6f)
                lineToRelative(0.27f, 2.0f)
                horizontalLineTo(6.93f)
                close()
            }
        }
        return _tableRestaurant!!
    }

private var _tableRestaurant: ImageVector? = null
