/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Rsvp: ImageVector
    get() {
        if (_rsvp != null) {
            return _rsvp!!
        }
        _rsvp = materialIcon(name = "Sharp.Rsvp") {
            materialPath {
                moveTo(16.0f, 9.0f)
                horizontalLineToRelative(1.5f)
                lineToRelative(-1.75f, 6.0f)
                horizontalLineToRelative(-1.5f)
                lineTo(12.5f, 9.0f)
                horizontalLineTo(14.0f)
                lineToRelative(1.0f, 3.43f)
                lineTo(16.0f, 9.0f)
                close()
                moveTo(5.14f, 13.0f)
                lineTo(6.0f, 15.0f)
                horizontalLineTo(4.5f)
                lineToRelative(-0.85f, -2.0f)
                horizontalLineTo(2.5f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(4.0f)
                lineTo(5.14f, 13.0f)
                close()
                moveTo(4.5f, 10.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.5f)
                close()
                moveTo(23.0f, 13.0f)
                horizontalLineToRelative(-3.5f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(18.0f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(21.5f, 10.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.5f)
                close()
                moveTo(11.5f, 9.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(0.75f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(15.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-0.75f)
                horizontalLineTo(7.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(11.5f)
                close()
            }
        }
        return _rsvp!!
    }

private var _rsvp: ImageVector? = null
