/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RoundaboutRight: ImageVector
    get() {
        if (_roundaboutRight != null) {
            return _roundaboutRight!!
        }
        _roundaboutRight = materialIcon(name = "Sharp.RoundaboutRight") {
            materialPath {
                moveTo(8.0f, 13.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -2.21f, 1.79f, -4.0f, 4.0f, -4.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, 1.79f, 4.0f, 4.0f)
                lineToRelative(0.0f, 1.0f)
                lineToRelative(6.17f, 0.0f)
                lineToRelative(-1.59f, 1.59f)
                lineTo(18.0f, 13.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(-4.0f, -4.0f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(18.17f, 8.0f)
                lineToRelative(-4.25f, 0.0f)
                curveTo(13.44f, 5.16f, 10.97f, 3.0f, 8.0f, 3.0f)
                curveTo(4.69f, 3.0f, 2.0f, 5.69f, 2.0f, 9.0f)
                curveToRelative(0.0f, 2.97f, 2.16f, 5.44f, 5.0f, 5.92f)
                lineTo(7.0f, 21.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(0.0f, -8.0f)
                lineTo(8.0f, 13.0f)
                close()
            }
        }
        return _roundaboutRight!!
    }

private var _roundaboutRight: ImageVector? = null
