/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PlayLesson: ImageVector
    get() {
        if (_playLesson != null) {
            return _playLesson!!
        }
        _playLesson = materialIcon(name = "Sharp.PlayLesson") {
            materialPath {
                moveTo(18.0f, 11.0f)
                curveToRelative(0.34f, 0.0f, 0.67f, 0.03f, 1.0f, 0.08f)
                verticalLineTo(2.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(20.0f)
                horizontalLineToRelative(9.26f)
                curveTo(11.47f, 20.87f, 11.0f, 19.49f, 11.0f, 18.0f)
                curveTo(11.0f, 14.13f, 14.13f, 11.0f, 18.0f, 11.0f)
                close()
                moveTo(7.0f, 11.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(7.0f)
                lineTo(9.5f, 9.5f)
                lineTo(7.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(16.75f, 20.5f)
                verticalLineToRelative(-5.0f)
                lineToRelative(4.0f, 2.5f)
                lineTo(16.75f, 20.5f)
                close()
            }
        }
        return _playLesson!!
    }

private var _playLesson: ImageVector? = null
