/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PinEnd: ImageVector
    get() {
        if (_pinEnd != null) {
            return _pinEnd!!
        }
        _pinEnd = materialIcon(name = "Sharp.PinEnd") {
            materialPath {
                moveTo(20.0f, 12.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(10.0f)
                lineToRelative(0.0f, 2.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(20.0f)
                verticalLineToRelative(8.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(19.0f, 14.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(20.66f, 14.0f, 19.0f, 14.0f)
                close()
                moveTo(14.66f, 8.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(5.66f)
                lineToRelative(2.12f, -2.12f)
                lineToRelative(2.83f, 2.83f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(-2.83f, -2.83f)
                lineTo(14.66f, 8.0f)
                close()
            }
        }
        return _pinEnd!!
    }

private var _pinEnd: ImageVector? = null
