/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PersonalInjury: ImageVector
    get() {
        if (_personalInjury != null) {
            return _personalInjury!!
        }
        _personalInjury = materialIcon(name = "Sharp.PersonalInjury") {
            materialPath {
                moveTo(8.0f, 6.0f)
                curveToRelative(0.0f, -2.21f, 1.79f, -4.0f, 4.0f, -4.0f)
                reflectiveCurveToRelative(4.0f, 1.79f, 4.0f, 4.0f)
                curveToRelative(0.0f, 2.21f, -1.79f, 4.0f, -4.0f, 4.0f)
                reflectiveCurveTo(8.0f, 8.21f, 8.0f, 6.0f)
                close()
                moveTo(17.0f, 22.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineToRelative(0.0f, -4.78f)
                curveToRelative(0.0f, -1.12f, -0.61f, -2.15f, -1.61f, -2.66f)
                curveToRelative(-0.43f, -0.22f, -0.9f, -0.43f, -1.39f, -0.62f)
                lineTo(17.0f, 22.0f)
                close()
                moveTo(12.34f, 17.0f)
                lineTo(15.0f, 11.33f)
                curveTo(14.07f, 11.12f, 13.07f, 11.0f, 12.0f, 11.0f)
                curveToRelative(-2.53f, 0.0f, -4.71f, 0.7f, -6.39f, 1.56f)
                curveTo(4.61f, 13.07f, 4.0f, 14.1f, 4.0f, 15.22f)
                lineTo(4.0f, 22.0f)
                horizontalLineToRelative(2.34f)
                curveTo(6.12f, 21.55f, 6.0f, 21.04f, 6.0f, 20.5f)
                curveTo(6.0f, 18.57f, 7.57f, 17.0f, 9.5f, 17.0f)
                horizontalLineTo(12.34f)
                close()
                moveTo(10.0f, 22.0f)
                lineToRelative(1.41f, -3.0f)
                horizontalLineTo(9.5f)
                curveTo(8.67f, 19.0f, 8.0f, 19.67f, 8.0f, 20.5f)
                reflectiveCurveTo(8.67f, 22.0f, 9.5f, 22.0f)
                horizontalLineTo(10.0f)
                close()
            }
        }
        return _personalInjury!!
    }

private var _personalInjury: ImageVector? = null
