/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NoFlash: ImageVector
    get() {
        if (_noFlash != null) {
            return _noFlash!!
        }
        _noFlash = materialIcon(name = "Sharp.NoFlash") {
            materialPath {
                moveTo(2.45f, 2.45f)
                lineTo(1.04f, 3.87f)
                lineToRelative(5.3f, 5.3f)
                lineTo(6.14f, 9.4f)
                horizontalLineTo(2.0f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-1.17f)
                lineToRelative(2.13f, 2.13f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.45f, 2.45f)
                close()
                moveTo(10.0f, 20.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -1.95f, 1.4f, -3.57f, 3.25f, -3.92f)
                lineToRelative(1.57f, 1.57f)
                curveToRelative(-0.26f, -0.09f, -0.53f, -0.15f, -0.82f, -0.15f)
                curveToRelative(-1.38f, 0.0f, -2.5f, 1.12f, -2.5f, 2.5f)
                curveToRelative(0.0f, 1.38f, 1.12f, 2.5f, 2.5f, 2.5f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                curveToRelative(0.0f, -0.29f, -0.06f, -0.56f, -0.15f, -0.82f)
                lineToRelative(1.57f, 1.57f)
                curveTo(13.57f, 18.6f, 11.95f, 20.0f, 10.0f, 20.0f)
                close()
                moveTo(18.0f, 15.17f)
                lineTo(10.83f, 8.0f)
                horizontalLineToRelative(1.75f)
                lineToRelative(1.28f, 1.4f)
                horizontalLineTo(18.0f)
                verticalLineTo(15.17f)
                close()
                moveTo(20.4f, 5.6f)
                horizontalLineTo(22.0f)
                lineTo(19.0f, 11.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(4.0f)
                lineTo(20.4f, 5.6f)
                close()
            }
        }
        return _noFlash!!
    }

private var _noFlash: ImageVector? = null
