/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.NetworkWifi3Bar: ImageVector
    get() {
        if (_networkWifi3Bar != null) {
            return _networkWifi3Bar!!
        }
        _networkWifi3Bar = materialIcon(name = "Sharp.NetworkWifi3Bar") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveTo(7.31f, 4.0f, 3.07f, 5.9f, 0.0f, 8.98f)
                lineTo(12.0f, 21.0f)
                lineTo(24.0f, 8.98f)
                curveTo(20.93f, 5.9f, 16.69f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(2.92f, 9.07f)
                curveTo(5.51f, 7.08f, 8.67f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveToRelative(6.49f, 1.08f, 9.08f, 3.07f)
                lineToRelative(-2.85f, 2.86f)
                curveTo(16.46f, 10.71f, 14.31f, 10.0f, 12.0f, 10.0f)
                curveToRelative(-2.31f, 0.0f, -4.46f, 0.71f, -6.23f, 1.93f)
                lineTo(2.92f, 9.07f)
                close()
            }
        }
        return _networkWifi3Bar!!
    }

private var _networkWifi3Bar: ImageVector? = null
