/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.MarkChatRead: ImageVector
    get() {
        if (_markChatRead != null) {
            return _markChatRead!!
        }
        _markChatRead = materialIcon(name = "Sharp.MarkChatRead") {
            materialPath {
                moveTo(12.03f, 17.5f)
                curveTo(12.01f, 17.67f, 12.0f, 17.83f, 12.0f, 18.0f)
                verticalLineToRelative(0.0f)
                horizontalLineTo(6.0f)
                lineToRelative(-4.0f, 4.0f)
                verticalLineTo(2.0f)
                horizontalLineToRelative(20.0f)
                verticalLineToRelative(8.68f)
                curveTo(21.09f, 10.25f, 20.08f, 10.0f, 19.0f, 10.0f)
                curveToRelative(-3.87f, 0.0f, -7.0f, 3.13f, -7.0f, 7.0f)
                curveTo(12.0f, 17.17f, 12.01f, 17.33f, 12.03f, 17.5f)
                close()
                moveTo(23.0f, 14.34f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-4.24f, 4.24f)
                lineToRelative(-2.12f, -2.12f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(17.34f, 20.0f)
                lineTo(23.0f, 14.34f)
                close()
            }
        }
        return _markChatRead!!
    }

private var _markChatRead: ImageVector? = null
