/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.MarkAsUnread: ImageVector
    get() {
        if (_markAsUnread != null) {
            return _markAsUnread!!
        }
        _markAsUnread = materialIcon(name = "Sharp.MarkAsUnread") {
            materialPath {
                moveTo(16.23f, 7.0f)
                lineToRelative(4.12f, 0.0f)
                lineToRelative(-9.85f, -5.0f)
                lineToRelative(-8.5f, 4.21f)
                lineToRelative(0.0f, 10.79f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -9.6f)
                lineToRelative(6.5f, -3.4f)
                close()
            }
            materialPath {
                moveTo(5.0f, 8.0f)
                verticalLineToRelative(13.0f)
                horizontalLineToRelative(17.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(5.0f)
                close()
                moveTo(20.0f, 12.0f)
                lineToRelative(-6.5f, 3.33f)
                lineTo(7.0f, 12.0f)
                verticalLineToRelative(-2.0f)
                lineToRelative(6.5f, 3.33f)
                lineTo(20.0f, 10.0f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _markAsUnread!!
    }

private var _markAsUnread: ImageVector? = null
