/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Man2: ImageVector
    get() {
        if (_man2 != null) {
            return _man2!!
        }
        _man2 = materialIcon(name = "Sharp.Man2") {
            materialPath {
                moveTo(16.0f, 7.0f)
                lineToRelative(-8.0f, 0.0f)
                lineToRelative(0.0f, 8.0f)
                lineToRelative(2.5f, 0.0f)
                lineToRelative(0.0f, 7.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(2.5f, 0.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 4.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _man2!!
    }

private var _man2: ImageVector? = null
