/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.LockPerson: ImageVector
    get() {
        if (_lockPerson != null) {
            return _lockPerson!!
        }
        _lockPerson = materialIcon(name = "Sharp.LockPerson") {
            materialPath {
                moveTo(16.43f, 11.18f)
                curveToRelative(1.26f, -0.29f, 2.47f, -0.21f, 3.57f, 0.12f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(6.22f)
                curveToRelative(0.0f, -2.61f, -1.91f, -4.94f, -4.51f, -5.19f)
                curveTo(9.51f, 0.74f, 7.0f, 3.08f, 7.0f, 6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(8.26f)
                curveToRelative(-1.01f, -1.45f, -1.5f, -3.3f, -1.15f, -5.27f)
                curveTo(11.6f, 14.0f, 13.74f, 11.79f, 16.43f, 11.18f)
                close()
                moveTo(8.9f, 6.0f)
                curveToRelative(0.0f, -1.71f, 1.39f, -3.1f, 3.1f, -3.1f)
                reflectiveCurveToRelative(3.1f, 1.39f, 3.1f, 3.1f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(8.9f)
                verticalLineTo(6.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(18.0f, 15.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(18.83f, 18.0f, 18.0f, 18.0f)
                reflectiveCurveToRelative(-1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveTo(17.17f, 15.0f, 18.0f, 15.0f)
                close()
                moveTo(18.0f, 21.0f)
                curveToRelative(-1.03f, 0.0f, -1.94f, -0.52f, -2.48f, -1.32f)
                curveTo(16.25f, 19.26f, 17.09f, 19.0f, 18.0f, 19.0f)
                reflectiveCurveToRelative(1.75f, 0.26f, 2.48f, 0.68f)
                curveTo(19.94f, 20.48f, 19.03f, 21.0f, 18.0f, 21.0f)
                close()
            }
        }
        return _lockPerson!!
    }

private var _lockPerson: ImageVector? = null
