/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Living: ImageVector
    get() {
        if (_living != null) {
            return _living!!
        }
        _living = materialIcon(name = "Sharp.Living") {
            materialPath {
                moveTo(15.5f, 12.0f)
                lineToRelative(0.0f, 2.5f)
                lineToRelative(-7.0f, 0.0f)
                lineToRelative(0.0f, -2.5f)
                lineToRelative(-0.98f, 0.0f)
                lineToRelative(-1.02f, 0.0f)
                lineToRelative(0.0f, 4.5f)
                lineToRelative(11.0f, 0.0f)
                lineToRelative(0.0f, -4.5f)
                close()
            }
            materialPath {
                moveTo(10.0f, 10.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(4.0f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(2.25f, -0.01f)
                lineToRelative(0.0f, -2.49f)
                lineToRelative(-8.5f, 0.0f)
                lineToRelative(0.0f, 2.49f)
                close()
            }
            materialPath {
                moveTo(22.0f, 2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(20.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(2.0f)
                close()
                moveTo(19.0f, 9.99f)
                verticalLineTo(18.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-8.0f)
                lineToRelative(1.25f, -0.01f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(11.5f)
                verticalLineToRelative(3.99f)
                horizontalLineTo(19.0f)
                close()
            }
        }
        return _living!!
    }

private var _living: ImageVector? = null
