/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.HdrAuto: ImageVector
    get() {
        if (_hdrAuto != null) {
            return _hdrAuto!!
        }
        _hdrAuto = materialIcon(name = "Sharp.HdrAuto") {
            materialPath {
                moveTo(12.04f, 8.04f)
                lineToRelative(-0.09f, 0.0f)
                lineToRelative(-1.6f, 4.55f)
                lineToRelative(3.29f, 0.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(15.21f, 17.0f)
                lineToRelative(-0.98f, -2.81f)
                horizontalLineTo(9.78f)
                lineToRelative(-1.0f, 2.81f)
                horizontalLineToRelative(-1.9f)
                lineToRelative(4.13f, -11.0f)
                horizontalLineToRelative(1.97f)
                lineToRelative(4.13f, 11.0f)
                horizontalLineTo(15.21f)
                close()
            }
        }
        return _hdrAuto!!
    }

private var _hdrAuto: ImageVector? = null
