/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Face5: ImageVector
    get() {
        if (_face5 != null) {
            return _face5!!
        }
        _face5 = materialIcon(name = "Sharp.Face5") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -1.12f, 0.23f, -2.18f, 0.65f, -3.15f)
                curveTo(4.74f, 8.94f, 4.86f, 9.0f, 5.0f, 9.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                curveToRelative(0.0f, -0.25f, -0.19f, -0.45f, -0.43f, -0.49f)
                curveToRelative(0.15f, -0.26f, 0.32f, -0.51f, 0.49f, -0.75f)
                curveTo(5.53f, 7.34f, 5.5f, 7.41f, 5.5f, 7.5f)
                curveTo(5.5f, 7.78f, 5.72f, 8.0f, 6.0f, 8.0f)
                reflectiveCurveToRelative(0.5f, -0.22f, 0.5f, -0.5f)
                curveTo(6.5f, 7.22f, 6.28f, 7.0f, 6.0f, 7.0f)
                curveTo(5.87f, 7.0f, 5.75f, 7.05f, 5.66f, 7.13f)
                curveToRelative(0.52f, -0.68f, 1.15f, -1.28f, 1.86f, -1.76f)
                curveTo(7.51f, 5.41f, 7.5f, 5.45f, 7.5f, 5.5f)
                curveTo(7.5f, 5.78f, 7.72f, 6.0f, 8.0f, 6.0f)
                reflectiveCurveToRelative(0.5f, -0.22f, 0.5f, -0.5f)
                curveToRelative(0.0f, -0.24f, -0.17f, -0.43f, -0.4f, -0.48f)
                curveToRelative(0.16f, -0.09f, 0.32f, -0.17f, 0.49f, -0.25f)
                curveTo(8.68f, 4.91f, 8.83f, 5.0f, 9.0f, 5.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                curveToRelative(0.0f, -0.03f, -0.01f, -0.06f, -0.02f, -0.09f)
                curveToRelative(0.39f, -0.13f, 0.79f, -0.23f, 1.21f, -0.3f)
                curveTo(10.58f, 4.21f, 10.5f, 4.34f, 10.5f, 4.5f)
                curveTo(10.5f, 4.78f, 10.72f, 5.0f, 11.0f, 5.0f)
                reflectiveCurveToRelative(0.5f, -0.22f, 0.5f, -0.5f)
                curveToRelative(0.0f, -0.21f, -0.13f, -0.38f, -0.3f, -0.46f)
                curveTo(11.46f, 4.01f, 11.73f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveToRelative(0.54f, 0.01f, 0.8f, 0.04f)
                curveToRelative(-0.18f, 0.08f, -0.3f, 0.25f, -0.3f, 0.46f)
                curveTo(12.5f, 4.78f, 12.72f, 5.0f, 13.0f, 5.0f)
                reflectiveCurveToRelative(0.5f, -0.22f, 0.5f, -0.5f)
                curveToRelative(0.0f, -0.16f, -0.08f, -0.29f, -0.19f, -0.38f)
                curveToRelative(0.41f, 0.07f, 0.82f, 0.17f, 1.21f, 0.3f)
                curveTo(14.51f, 4.44f, 14.5f, 4.47f, 14.5f, 4.5f)
                curveTo(14.5f, 4.78f, 14.72f, 5.0f, 15.0f, 5.0f)
                curveToRelative(0.17f, 0.0f, 0.32f, -0.09f, 0.41f, -0.23f)
                curveToRelative(0.17f, 0.08f, 0.33f, 0.16f, 0.49f, 0.25f)
                curveToRelative(-0.23f, 0.05f, -0.4f, 0.24f, -0.4f, 0.48f)
                curveTo(15.5f, 5.78f, 15.72f, 6.0f, 16.0f, 6.0f)
                reflectiveCurveToRelative(0.5f, -0.22f, 0.5f, -0.5f)
                curveToRelative(0.0f, -0.05f, -0.01f, -0.09f, -0.03f, -0.13f)
                curveToRelative(0.71f, 0.48f, 1.34f, 1.08f, 1.86f, 1.76f)
                curveTo(18.25f, 7.05f, 18.13f, 7.0f, 18.0f, 7.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                curveTo(17.5f, 7.78f, 17.72f, 8.0f, 18.0f, 8.0f)
                reflectiveCurveToRelative(0.5f, -0.22f, 0.5f, -0.5f)
                curveToRelative(0.0f, -0.09f, -0.03f, -0.16f, -0.07f, -0.23f)
                curveToRelative(0.18f, 0.24f, 0.34f, 0.49f, 0.49f, 0.75f)
                curveTo(18.69f, 8.05f, 18.5f, 8.25f, 18.5f, 8.5f)
                curveTo(18.5f, 8.78f, 18.72f, 9.0f, 19.0f, 9.0f)
                curveToRelative(0.14f, 0.0f, 0.26f, -0.06f, 0.35f, -0.15f)
                curveTo(19.77f, 9.82f, 20.0f, 10.88f, 20.0f, 12.0f)
                curveTo(20.0f, 16.41f, 16.41f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(9.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 5.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(14.0f, 5.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(10.0f, 5.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(17.0f, 6.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(9.0f, 6.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(7.0f, 6.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(11.0f, 6.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(13.0f, 6.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 6.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(12.0f, 7.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(14.0f, 7.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(16.0f, 7.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(10.0f, 7.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(8.0f, 7.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(9.0f, 8.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(7.0f, 8.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(11.0f, 8.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(13.0f, 8.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 8.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(17.0f, 8.5f)
                moveToRelative(-0.5f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, 1.0f, 0.0f)
                arcToRelative(0.5f, 0.5f, 0.0f, true, true, -1.0f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
        }
        return _face5!!
    }

private var _face5: ImageVector? = null
