/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.EditOff: ImageVector
    get() {
        if (_editOff != null) {
            return _editOff!!
        }
        _editOff = materialIcon(name = "Sharp.EditOff") {
            materialPath {
                moveTo(21.41f, 6.33f)
                lineToRelative(-3.75f, -3.75f)
                lineToRelative(-2.53f, 2.54f)
                lineToRelative(3.75f, 3.75f)
                lineTo(21.41f, 6.33f)
                close()
                moveTo(1.39f, 4.22f)
                lineToRelative(7.32f, 7.32f)
                lineTo(3.0f, 17.25f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(3.75f)
                lineToRelative(5.71f, -5.71f)
                lineToRelative(7.32f, 7.32f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                close()
                moveTo(17.81f, 9.94f)
                lineToRelative(-3.75f, -3.75f)
                lineToRelative(-2.52f, 2.52f)
                lineToRelative(3.75f, 3.75f)
                lineTo(17.81f, 9.94f)
                close()
            }
        }
        return _editOff!!
    }

private var _editOff: ImageVector? = null
