/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.DesktopMac: ImageVector
    get() {
        if (_desktopMac != null) {
            return _desktopMac!!
        }
        _desktopMac = materialIcon(name = "Sharp.DesktopMac") {
            materialPath {
                moveTo(23.0f, 2.0f)
                lineTo(1.0f, 2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(9.0f)
                lineToRelative(-2.0f, 3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-1.0f)
                lineToRelative(-2.0f, -3.0f)
                horizontalLineToRelative(9.0f)
                lineTo(23.0f, 2.0f)
                close()
                moveTo(21.0f, 14.0f)
                lineTo(3.0f, 14.0f)
                lineTo(3.0f, 4.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(10.0f)
                close()
            }
        }
        return _desktopMac!!
    }

private var _desktopMac: ImageVector? = null
